/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.toolbar;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.DecisionService;
import org.kie.workbench.common.dmn.client.widgets.toolbar.DMNGraphProcessor;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNGraphProcessorTest {
    @Test
    public void testGetNodes() {
        DMNGraphProcessor processor = new DMNGraphProcessor();
        Graph graph = (Graph)Mockito.mock(Graph.class);
        Decision decision1 = (Decision)Mockito.mock(Decision.class);
        Decision decision2 = (Decision)Mockito.mock(Decision.class);
        Node node1 = this.createNode(decision1, "id1");
        Node node2 = this.createNode(decision2, "id2");
        List<Node> graphNodes = this.createGraphNodes(node1, node2);
        Mockito.when((Object)graph.nodes()).thenReturn(graphNodes);
        Iterable nodes = processor.getNodes(graph);
        for (Node node : nodes) {
            TestCase.assertTrue((boolean)graphNodes.contains(node));
            TestCase.assertFalse((boolean)processor.isReplacedByAnotherNode(node.getUUID()));
        }
    }

    @Test
    public void testGetNodesWithDecisionServices() {
        String childId1 = "id1";
        String childId2 = "id2";
        String dsId = "dsId";
        String decisionNodeId = "decision1Node";
        DMNGraphProcessor processor = (DMNGraphProcessor)Mockito.spy((Object)new DMNGraphProcessor());
        Graph graph = (Graph)Mockito.mock(Graph.class);
        Decision decision1 = (Decision)Mockito.mock(Decision.class);
        Node decisionNode = this.createNode(decision1, "decision1Node");
        DecisionService ds = (DecisionService)Mockito.mock(DecisionService.class);
        Node dsNode = this.createNode(ds, "dsId");
        Decision child1 = (Decision)Mockito.mock(Decision.class);
        Node ch1 = this.createNode(child1, "id1");
        Decision child2 = (Decision)Mockito.mock(Decision.class);
        Node ch2 = this.createNode(child2, "id2");
        List<Node> children = Arrays.asList(ch1, ch2);
        ((DMNGraphProcessor)Mockito.doReturn(children).when((Object)processor)).getChildNodes(dsNode);
        List<Node> graphNodes = this.createGraphNodes(dsNode, decisionNode);
        Mockito.when((Object)graph.nodes()).thenReturn(graphNodes);
        List nodes = (List)processor.getNodes(graph);
        TestCase.assertEquals((int)2, (int)nodes.size());
        TestCase.assertTrue((boolean)nodes.contains(dsNode));
        TestCase.assertTrue((boolean)nodes.contains(decisionNode));
        TestCase.assertTrue((boolean)processor.isReplacedByAnotherNode("id1"));
        TestCase.assertEquals((String)"dsId", (String)processor.getReplaceNodeId("id1"));
        TestCase.assertTrue((boolean)processor.isReplacedByAnotherNode("id2"));
        TestCase.assertEquals((String)"dsId", (String)processor.getReplaceNodeId("id2"));
    }

    private List<Node> createGraphNodes(Node ... nodes) {
        return Arrays.asList(nodes);
    }

    private Node createNode(Object definition, String nodeId) {
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getUUID()).thenReturn((Object)nodeId);
        Definition content = (Definition)Mockito.mock(Definition.class);
        Mockito.when((Object)node.getContent()).thenReturn((Object)content);
        Mockito.when((Object)content.getDefinition()).thenReturn(definition);
        return node;
    }
}

