/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.canvas.controls.toolbox;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.dmn.client.canvas.controls.toolbox.DMNFlowActionsToolbox;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.AbstractActionsToolboxFactory;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ActionsToolboxView;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.CreateConnectorToolboxAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.CreateNodeToolboxAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.FlowActionsToolbox;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ToolboxAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ToolboxDomainLookups;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.lookup.domain.CommonDomainLookups;

@Dependent
@DMNFlowActionsToolbox
public class DMNFlowActionsToolboxFactory
extends AbstractActionsToolboxFactory {
    private final ToolboxDomainLookups toolboxDomainLookups;
    private final ManagedInstance<CreateConnectorToolboxAction> createConnectorActions;
    private final ManagedInstance<CreateNodeToolboxAction> createNodeActions;
    private final ManagedInstance<ActionsToolboxView> views;

    @Inject
    public DMNFlowActionsToolboxFactory(ToolboxDomainLookups toolboxDomainLookups, @Any ManagedInstance<CreateConnectorToolboxAction> createConnectorActions, @Any @DMNFlowActionsToolbox ManagedInstance<CreateNodeToolboxAction> createNodeActions, @Any @FlowActionsToolbox ManagedInstance<ActionsToolboxView> views) {
        this.toolboxDomainLookups = toolboxDomainLookups;
        this.createConnectorActions = createConnectorActions;
        this.createNodeActions = createNodeActions;
        this.views = views;
    }

    protected ActionsToolboxView<?> newViewInstance() {
        return (ActionsToolboxView)this.views.get();
    }

    public Collection<ToolboxAction<AbstractCanvasHandler>> getActions(AbstractCanvasHandler canvasHandler, Element<?> element) {
        LinkedHashSet<ToolboxAction<AbstractCanvasHandler>> actions = new LinkedHashSet<ToolboxAction<AbstractCanvasHandler>>();
        Node node = (Node)element;
        Diagram diagram = canvasHandler.getDiagram();
        String defSetId = diagram.getMetadata().getDefinitionSetId();
        CommonDomainLookups lookup = this.toolboxDomainLookups.get(defSetId);
        Set allowedConnectorIds = lookup.lookupTargetConnectors(node);
        for (String allowedConnectorId : allowedConnectorIds) {
            actions.add((ToolboxAction<AbstractCanvasHandler>)((CreateConnectorToolboxAction)this.createConnectorActions.get()).setEdgeId(allowedConnectorId));
            Set defIds = lookup.lookupTargetNodes(diagram.getGraph(), node, allowedConnectorId);
            defIds.forEach(definitionId -> actions.add((ToolboxAction<AbstractCanvasHandler>)((CreateNodeToolboxAction)this.createNodeActions.get()).setEdgeId(allowedConnectorId).setNodeId(definitionId)));
        }
        return actions;
    }

    @PreDestroy
    public void destroy() {
        this.createConnectorActions.destroyAll();
        this.createNodeActions.destroyAll();
        this.views.destroyAll();
    }
}

