/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator;

import java.util.Objects;
import java.util.TreeSet;
import org.uberfire.mvp.Command;

public class DecisionNavigatorItem
implements Comparable {
    private String uuid;
    private String label;
    private Type type;
    private Command onClick;
    private String parentUUID;
    private TreeSet<DecisionNavigatorItem> children = new TreeSet();

    public DecisionNavigatorItem(String uuid, String label, Type type, Command onClick, String parentUUID) {
        this.uuid = uuid;
        this.label = label;
        this.type = type;
        this.onClick = onClick;
        this.parentUUID = parentUUID;
    }

    public DecisionNavigatorItem(String uuid) {
        this.uuid = uuid;
    }

    public String getUUID() {
        return this.uuid;
    }

    public String getLabel() {
        return this.label;
    }

    public Type getType() {
        return this.type;
    }

    public TreeSet<DecisionNavigatorItem> getChildren() {
        return this.children;
    }

    public void removeChild(DecisionNavigatorItem item) {
        this.getChildren().removeIf(i -> i.getUUID().equals(item.getUUID()));
    }

    public void addChild(DecisionNavigatorItem item) {
        this.removeChild(item);
        this.getChildren().add(item);
    }

    public void onClick() {
        this.onClick.execute();
    }

    public Command getOnClick() {
        return this.onClick;
    }

    public String getParentUUID() {
        return this.parentUUID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecisionNavigatorItem item = (DecisionNavigatorItem)o;
        return Objects.equals(this.uuid, item.uuid) && Objects.equals(this.label, item.label) && Objects.equals(this.parentUUID, item.parentUUID) && this.type == item.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.uuid, this.label, this.type, this.parentUUID});
    }

    public int compareTo(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return 1;
        }
        DecisionNavigatorItem that = (DecisionNavigatorItem)o;
        if (this.equals(that)) {
            return 0;
        }
        return this.getOrderingName().compareTo(that.getOrderingName());
    }

    String getOrderingName() {
        String orderingLabel = this.getLabel() + this.getUUID();
        return orderingLabel.toLowerCase();
    }

    public static enum Type {
        ROOT,
        ITEM,
        CONTEXT,
        DECISION_TABLE,
        FUNCTION_DEFINITION,
        INVOCATION,
        LIST,
        LITERAL_EXPRESSION,
        RELATION;

    }
}

