/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator.included.components;

import java.util.Map;
import org.kie.soup.commons.util.Maps;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.client.shape.def.DMNSVGShapeDefImpl;
import org.kie.workbench.common.stunner.core.client.shape.ImageDataUriGlyph;

public class DecisionComponent {
    private final String fileName;
    private DRGElement drgElement;
    private static final Map<Class<?>, ImageDataUriGlyph> PALETTE_MAP = DecisionComponent.buildPaletteMap();

    public DecisionComponent(String fileName, DRGElement drgElement) {
        this.fileName = fileName;
        this.drgElement = drgElement;
    }

    public String getFileName() {
        return this.fileName;
    }

    public DRGElement getDrgElement() {
        return this.drgElement;
    }

    public String getName() {
        return this.drgElement.getName().getValue();
    }

    public ImageDataUriGlyph getIcon() {
        return PALETTE_MAP.get(this.drgElement.getClass());
    }

    private static Map<Class<?>, ImageDataUriGlyph> buildPaletteMap() {
        Maps.Builder map = new Maps.Builder();
        DMNSVGShapeDefImpl.GLYPHS_PALETTE.forEach((aClass, glyph) -> map.put(aClass, (Object)((ImageDataUriGlyph)glyph)));
        return map.build();
    }
}

