/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator.included.components;

import elemental2.dom.HTMLElement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.kie.workbench.common.dmn.api.definition.model.Import;
import org.kie.workbench.common.dmn.api.editors.included.DMNImportTypes;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedNode;
import org.kie.workbench.common.dmn.client.api.included.legacy.DMNIncludeModelsClient;
import org.kie.workbench.common.dmn.client.docks.navigator.included.components.DecisionComponent;
import org.kie.workbench.common.dmn.client.docks.navigator.included.components.DecisionComponentFilter;
import org.kie.workbench.common.dmn.client.docks.navigator.included.components.DecisionComponentsItem;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.uberfire.client.mvp.UberElemental;

@Dependent
public class DecisionComponents {
    private final View view;
    private final DMNGraphUtils graphUtils;
    private final DMNIncludeModelsClient client;
    private final ManagedInstance<DecisionComponentsItem> itemManagedInstance;
    private final DecisionComponentFilter filter;
    private final List<DecisionComponentsItem> decisionComponentsItems = new ArrayList<DecisionComponentsItem>();

    @Inject
    public DecisionComponents(View view, DMNGraphUtils graphUtils, DMNIncludeModelsClient client, ManagedInstance<DecisionComponentsItem> itemManagedInstance, DecisionComponentFilter filter) {
        this.view = view;
        this.graphUtils = graphUtils;
        this.client = client;
        this.itemManagedInstance = itemManagedInstance;
        this.filter = filter;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public View getView() {
        return this.view;
    }

    public void refresh(Diagram diagram) {
        this.clearDecisionComponents();
        this.startLoading();
        this.client.loadNodesFromImports(this.getDMNIncludedModels(diagram), this.getNodesConsumer());
    }

    Consumer<List<DMNIncludedNode>> getNodesConsumer() {
        return nodes -> {
            this.view.setComponentsCounter(nodes.size());
            this.view.hideLoading();
            if (!nodes.isEmpty()) {
                nodes.forEach(this::addComponent);
                this.view.enableFilterInputs();
            } else {
                this.view.showEmptyState();
            }
        };
    }

    void startLoading() {
        this.view.showLoading();
        this.view.disableFilterInputs();
    }

    void clearDecisionComponents() {
        this.getDecisionComponentsItems().clear();
        this.view.clear();
    }

    void applyFilter() {
        this.hideAllItems();
        this.showFilteredItems();
    }

    void applyTermFilter(String value) {
        this.getFilter().setTerm(value);
        this.applyFilter();
    }

    void applyDrgElementFilterFilter(String value) {
        this.getFilter().setDrgElement(value);
        this.applyFilter();
    }

    private void showFilteredItems() {
        this.getFilter().query(this.getDecisionComponentsItems().stream()).sorted(Comparator.comparing(item -> item.getDecisionComponent().getName())).forEach(DecisionComponentsItem::show);
    }

    private void hideAllItems() {
        this.getDecisionComponentsItems().forEach(DecisionComponentsItem::hide);
    }

    void addComponent(DMNIncludedNode node) {
        DecisionComponentsItem item = (DecisionComponentsItem)this.itemManagedInstance.get();
        item.setDecisionComponent(this.makeDecisionComponent(node));
        this.getDecisionComponentsItems().add(item);
        this.view.addListItem(item.getView().getElement());
    }

    private DecisionComponent makeDecisionComponent(DMNIncludedNode node) {
        return new DecisionComponent(node.getFileName(), node.getDrgElement());
    }

    List<DMNIncludedModel> getDMNIncludedModels(Diagram diagram) {
        return this.graphUtils.getDefinitions(diagram).getImport().stream().filter(anImport -> Objects.equals(DMNImportTypes.DMN, DMNImportTypes.determineImportType((String)anImport.getImportType()))).map(this::asDMNIncludedModel).collect(Collectors.toList());
    }

    private DMNIncludedModel asDMNIncludedModel(Import anImport) {
        String modelName = anImport.getName().getValue();
        String namespace = anImport.getNamespace();
        String importType = anImport.getImportType();
        return new DMNIncludedModel(modelName, "", "", namespace, importType, Integer.valueOf(0), Integer.valueOf(0));
    }

    List<DecisionComponentsItem> getDecisionComponentsItems() {
        return this.decisionComponentsItems;
    }

    DecisionComponentFilter getFilter() {
        return this.filter;
    }

    public void removeAllItems() {
        this.clearDecisionComponents();
    }

    public static interface View
    extends UberElemental<DecisionComponents>,
    IsElement {
        public void clear();

        public void addListItem(HTMLElement var1);

        public void showEmptyState();

        public void showLoading();

        public void hideLoading();

        public void disableFilterInputs();

        public void enableFilterInputs();

        public void setComponentsCounter(Integer var1);
    }
}

