/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator.tree;

import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.DomGlobal;
import elemental2.dom.Element;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLUListElement;
import elemental2.dom.Node;
import elemental2.dom.Text;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItem;
import org.kie.workbench.common.dmn.client.docks.navigator.tree.DecisionNavigatorTreePresenter;
import org.kie.workbench.common.dmn.client.editors.common.RemoveHelper;
import org.uberfire.client.views.pfly.selectpicker.ElementHelper;

@Templated
public class DecisionNavigatorTreeView
implements DecisionNavigatorTreePresenter.View {
    @DataField(value="view")
    private HTMLDivElement view;
    @DataField(value="items")
    private HTMLDivElement items;
    private ManagedInstance<TreeItem> managedInstance;
    private Elemental2DomUtil util;
    private DecisionNavigatorTreePresenter presenter;
    private Element selectedElement;

    @Inject
    public DecisionNavigatorTreeView(HTMLDivElement view, HTMLDivElement items, ManagedInstance<TreeItem> managedInstance, Elemental2DomUtil util) {
        this.view = view;
        this.items = items;
        this.managedInstance = managedInstance;
        this.util = util;
    }

    public void init(DecisionNavigatorTreePresenter presenter) {
        this.presenter = presenter;
    }

    public HTMLElement getElement() {
        return this.view;
    }

    @Override
    public void clean() {
        RemoveHelper.removeChildren((Element)this.items);
    }

    @Override
    public void setup(List<DecisionNavigatorItem> items) {
        this.items.appendChild((Node)this.makeTree(items));
    }

    @Override
    public void addItem(DecisionNavigatorItem item, DecisionNavigatorItem nextItem) {
        String uuid = item.getParentUUID();
        Element parentElement = this.findTreeItemElement(uuid);
        Element parentChildrenElement = this.findTreeItemChildrenElement(uuid);
        Element newChild = this.makeTreeItemElement(item);
        Element refChild = this.findItem(nextItem);
        parentElement.classList.add(new String[]{"parent-node"});
        parentChildrenElement.insertBefore((Node)newChild, (Node)refChild);
    }

    @Override
    public void update(DecisionNavigatorItem item, DecisionNavigatorItem nextItem) {
        Element parentElement = this.findTreeItemChildrenElement(item.getParentUUID());
        Element oldChild = this.findItem(item);
        Element newChild = this.makeTreeItemElement(item);
        Element refChild = this.findItem(nextItem);
        if (oldChild != null) {
            parentElement.removeChild((Node)oldChild);
        }
        parentElement.insertBefore((Node)newChild, (Node)refChild);
    }

    @Override
    public boolean hasItem(DecisionNavigatorItem item) {
        return this.findItem(item) != null;
    }

    @Override
    public void remove(DecisionNavigatorItem item) {
        Optional.ofNullable(this.findItem(item)).ifPresent(element -> {
            if (element.parentNode != null) {
                ElementHelper.remove((Node)element);
            }
        });
    }

    @Override
    public void select(String uuid) {
        Element newElement = this.findTreeItemTextElement(uuid);
        Element oldElement = this.getSelectedElement();
        this.deselect(oldElement);
        this.select(newElement);
        this.setSelectedElement(newElement);
    }

    @Override
    public void deselect() {
        this.deselect(this.getSelectedElement());
    }

    Element getSelectedElement() {
        return this.selectedElement;
    }

    void setSelectedElement(Element selectedElement) {
        this.selectedElement = selectedElement;
    }

    Element makeTree(Collection<DecisionNavigatorItem> items) {
        Element ulElement = this.createElement("ul");
        items.forEach(item -> ulElement.appendChild((Node)this.makeTreeItemElement((DecisionNavigatorItem)item)));
        return ulElement;
    }

    Element findItem(DecisionNavigatorItem decisionNavigatorItem) {
        Optional<DecisionNavigatorItem> item = Optional.ofNullable(decisionNavigatorItem);
        if (item.isPresent()) {
            return this.findTreeItemElement(item.get().getUUID());
        }
        return null;
    }

    Element makeTreeItemElement(DecisionNavigatorItem item) {
        Element childrenTree = this.makeTree(item.getChildren());
        TreeItem treeItem = ((TreeItem)this.managedInstance.get()).setup(item, childrenTree);
        return this.util.asHTMLElement(treeItem.getElement());
    }

    void select(Element element) {
        Optional.ofNullable(element).ifPresent(e -> e.classList.add(new String[]{"selected"}));
    }

    void deselect(Element element) {
        Optional.ofNullable(element).ifPresent(e -> e.classList.remove(new String[]{"selected"}));
    }

    Element findTreeItemElement(String uuid) {
        return this.itemsQuerySelector("[data-uuid=\"" + uuid + "\"]");
    }

    Element findTreeItemChildrenElement(String uuid) {
        return this.itemsQuerySelector("[data-uuid=\"" + uuid + "\"] ul");
    }

    Element findTreeItemTextElement(String uuid) {
        return this.itemsQuerySelector("[data-uuid=\"" + uuid + "\"] div");
    }

    Element createElement(String tagName) {
        return DomGlobal.document.createElement(tagName);
    }

    Element itemsQuerySelector(String selector) {
        return this.items.querySelector(selector);
    }

    @Templated(value="DecisionNavigatorTreeView.html#item")
    public static class TreeItem
    implements IsElement {
        @DataField(value="text")
        private HTMLDivElement text;
        @DataField(value="icon")
        private HTMLElement icon;
        @DataField(value="sub-items")
        private HTMLUListElement subItems;
        private DecisionNavigatorItem item;

        @Inject
        public TreeItem(HTMLDivElement text, @Named(value="span") HTMLElement icon, HTMLUListElement subItems) {
            this.text = text;
            this.icon = icon;
            this.subItems = subItems;
        }

        @EventHandler(value={"icon"})
        public void onIconClick(ClickEvent event) {
            this.toggle();
            event.stopPropagation();
        }

        @EventHandler(value={"text"})
        public void onTextClick(ClickEvent event) {
            this.getItem().onClick();
        }

        public TreeItem setup(DecisionNavigatorItem item, Element children) {
            this.item = item;
            this.updateDataUUID();
            this.updateTitle();
            this.updateCSSClass();
            this.updateLabel();
            this.updateSubItems(children);
            return this;
        }

        void updateDataUUID() {
            this.getElement().setAttribute("data-uuid", this.getItem().getUUID());
        }

        void updateTitle() {
            this.getElement().setAttribute("title", this.getItem().getLabel());
        }

        void updateCSSClass() {
            this.getElement().getClassList().add(this.getCSSClass(this.getItem()));
            if (this.getItem().getChildren().size() > 0) {
                this.getElement().getClassList().add("parent-node");
            }
        }

        void updateLabel() {
            this.text.appendChild((Node)this.getTextNode(this.getItem().getLabel()));
        }

        void updateSubItems(Element children) {
            this.subItems.parentNode.replaceChild((Node)children, (Node)this.subItems);
        }

        void toggle() {
            this.getElement().getClassList().toggle("closed");
        }

        String getCSSClass(DecisionNavigatorItem item) {
            String typeName = item.getType().name();
            return "kie-" + typeName.toLowerCase().replace('_', '-');
        }

        DecisionNavigatorItem getItem() {
            return this.item;
        }

        Text getTextNode(String label) {
            return DomGlobal.document.createTextNode(label);
        }
    }
}

