/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.preview;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.dmn.api.qualifiers.DMNEditor;
import org.kie.workbench.common.stunner.client.widgets.canvas.StunnerBoundsProviderFactory;
import org.kie.workbench.common.stunner.client.widgets.presenters.Viewer;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionDiagramPreview;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionViewer;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.event.SessionDestroyedEvent;
import org.kie.workbench.common.stunner.core.client.session.event.SessionDiagramOpenedEvent;
import org.kie.workbench.common.stunner.core.client.session.event.SessionOpenedEvent;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractSession;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.uberfire.client.annotations.WorkbenchContextId;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;

@Dependent
@WorkbenchScreen(identifier="DMNProjectDiagramExplorerScreen")
public class PreviewDiagramScreen {
    private static Logger LOGGER = Logger.getLogger(PreviewDiagramScreen.class.getName());
    private static final int PREVIEW_WIDTH = 420;
    private static final int PREVIEW_HEIGHT = StunnerBoundsProviderFactory.computeHeight((int)420);
    public static final String SCREEN_ID = "DMNProjectDiagramExplorerScreen";
    private final SessionManager clientSessionManager;
    private final ManagedInstance<SessionDiagramPreview<AbstractSession>> sessionPreviews;
    private final View view;
    private SessionDiagramPreview<AbstractSession> previewWidget;

    protected PreviewDiagramScreen() {
        this(null, null, null);
    }

    @Inject
    public PreviewDiagramScreen(SessionManager clientSessionManager, @Any @DMNEditor ManagedInstance<SessionDiagramPreview<AbstractSession>> sessionPreviews, View view) {
        this.clientSessionManager = clientSessionManager;
        this.sessionPreviews = sessionPreviews;
        this.view = view;
    }

    @OnStartup
    public void onStartup(PlaceRequest placeRequest) {
    }

    @OnOpen
    public void onOpen() {
        ClientSession current = this.clientSessionManager.getCurrentSession();
        if (Objects.nonNull(current)) {
            this.showPreview(current);
        }
    }

    @OnClose
    public void onClose() {
        this.closePreview();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return "Unused";
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return this.view;
    }

    @WorkbenchContextId
    public String getMyContextRef() {
        return "DMNProjectDiagramExplorerScreenContext";
    }

    void closePreview() {
        this.view.clearPreviewWidget();
        if (null != this.previewWidget) {
            this.previewWidget.destroy();
            this.sessionPreviews.destroy(this.previewWidget);
            this.previewWidget = null;
        }
    }

    void onCanvasSessionOpened(@Observes SessionOpenedEvent sessionOpenedEvent) {
        PortablePreconditions.checkNotNull((String)"sessionOpenedEvent", (Object)sessionOpenedEvent);
        this.showPreview(sessionOpenedEvent.getSession());
    }

    void onCanvasSessionDestroyed(@Observes SessionDestroyedEvent sessionDestroyedEvent) {
        PortablePreconditions.checkNotNull((String)"sessionDestroyedEvent", (Object)sessionDestroyedEvent);
        this.closePreview();
    }

    void onSessionDiagramOpenedEvent(@Observes SessionDiagramOpenedEvent sessionDiagramOpenedEvent) {
        PortablePreconditions.checkNotNull((String)"sessionDiagramOpenedEvent", (Object)sessionDiagramOpenedEvent);
        this.showPreview(sessionDiagramOpenedEvent.getSession());
    }

    void showPreview(ClientSession session) {
        if (Objects.isNull(session)) {
            return;
        }
        if (session instanceof AbstractSession) {
            if (Objects.nonNull(this.previewWidget)) {
                this.closePreview();
            }
            this.previewWidget = (SessionDiagramPreview)this.sessionPreviews.get();
            this.previewWidget.open((Object)((AbstractSession)session), 420, PREVIEW_HEIGHT, (Viewer.Callback)new SessionViewer.SessionViewerCallback<Diagram>(){

                public void afterCanvasInitialized() {
                }

                public void onSuccess() {
                    PreviewDiagramScreen.this.view.setPreviewWidget(PreviewDiagramScreen.this.previewWidget.getView());
                }

                public void onError(ClientRuntimeError error) {
                    LOGGER.log(Level.SEVERE, error.getMessage());
                }
            });
        }
    }

    public static interface View
    extends IsWidget {
        public void setPreviewWidget(IsWidget var1);

        public void clearPreviewWidget();
    }
}

