/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.common.messages;

import elemental2.dom.HTMLElement;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.kie.workbench.common.dmn.client.editors.common.messages.FlashMessage;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.mvp.Command;

@Dependent
public class FlashMessages {
    private final View view;
    private Command warningSuccessCallback;
    private Command warningErrorCallback;

    @Inject
    public FlashMessages(View view) {
        this.view = view;
    }

    @PostConstruct
    void init() {
        this.view.init(this);
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    public void onFlashMessageEvent(@Observes FlashMessage flashMessage) {
        boolean isElementPresent = this.view.isElementPresent(flashMessage.getElementSelector());
        if (isElementPresent) {
            this.registerFlashMessageCallback(flashMessage);
            this.showFlashMessage(flashMessage);
            this.highlighElement(flashMessage);
        }
    }

    void showFlashMessage(FlashMessage flashMessage) {
        switch (flashMessage.getType()) {
            case ERROR: {
                this.view.showErrorMessage(flashMessage.getStrongMessage(), flashMessage.getRegularMessage());
                break;
            }
            case WARNING: {
                this.view.showWarningMessage(flashMessage.getStrongMessage(), flashMessage.getRegularMessage());
            }
        }
    }

    void highlighElement(FlashMessage flashMessage) {
        switch (flashMessage.getType()) {
            case ERROR: {
                this.view.showErrorHighlight(flashMessage.getElementSelector());
                break;
            }
            case WARNING: {
                this.view.showWarningHighlight(flashMessage.getElementSelector());
            }
        }
    }

    void registerFlashMessageCallback(FlashMessage flashMessage) {
        switch (flashMessage.getType()) {
            case ERROR: {
                break;
            }
            case WARNING: {
                this.warningSuccessCallback = flashMessage.getOnSuccess();
                this.warningErrorCallback = flashMessage.getOnError();
            }
        }
    }

    void executeSuccessWarningCallback() {
        this.getWarningSuccessCallback().ifPresent(Command::execute);
    }

    void executeErrorWarningCallback() {
        this.getWarningErrorCallback().ifPresent(Command::execute);
    }

    private Optional<Command> getWarningErrorCallback() {
        return Optional.ofNullable(this.warningErrorCallback);
    }

    private Optional<Command> getWarningSuccessCallback() {
        return Optional.ofNullable(this.warningSuccessCallback);
    }

    public void hideMessages() {
        this.view.hideErrorContainer();
        this.view.hideWarningContainer();
    }

    public static interface View
    extends UberElemental<FlashMessages>,
    IsElement {
        public void showErrorMessage(String var1, String var2);

        public void showWarningMessage(String var1, String var2);

        public void showErrorHighlight(String var1);

        public void showWarningHighlight(String var1);

        public boolean isElementPresent(String var1);

        public void hideWarningContainer();

        public void hideErrorContainer();
    }
}

