/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.grid;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.HTMLElement;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.kie.workbench.common.dmn.client.docks.navigator.events.RefreshDecisionComponents;
import org.kie.workbench.common.dmn.client.editors.common.persistence.ActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.BaseIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.grid.DMNCardsGridComponent;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.kie.workbench.common.widgets.client.cards.CardComponent;
import org.uberfire.client.mvp.UberElemental;

public abstract class BaseCardComponent<R extends BaseIncludedModelActiveRecord, V extends ContentView>
implements CardComponent {
    protected final V contentView;
    protected final Event<RefreshDecisionComponents> refreshDecisionComponentsEvent;
    protected R includedModel;
    protected DMNCardsGridComponent grid;

    public BaseCardComponent(V contentView, Event<RefreshDecisionComponents> refreshDecisionComponentsEvent) {
        this.contentView = contentView;
        this.refreshDecisionComponentsEvent = refreshDecisionComponentsEvent;
    }

    @PostConstruct
    public void init() {
        this.contentView.init((Object)this);
    }

    public void setup(DMNCardsGridComponent grid, R includedModel) {
        this.grid = grid;
        this.includedModel = includedModel;
        this.refreshView();
    }

    protected void refreshView() {
        this.contentView.setPath(this.getTruncatedSubTitle());
    }

    public Style.HasCssName getIcon() {
        return IconType.DOWNLOAD;
    }

    public String getTitle() {
        return ((BaseIncludedModelActiveRecord)this.getIncludedModel()).getName();
    }

    public String getUUID() {
        return ((BaseIncludedModelActiveRecord)this.getIncludedModel()).getUUID();
    }

    public HTMLElement getContent() {
        return this.contentView.getElement();
    }

    public Function<String, Boolean> onTitleChanged() {
        return newName -> {
            String oldName = ((BaseIncludedModelActiveRecord)this.getIncludedModel()).getName();
            ((BaseIncludedModelActiveRecord)this.getIncludedModel()).setName((String)newName);
            if (((ActiveRecord)this.getIncludedModel()).isValid()) {
                ((ActiveRecord)this.getIncludedModel()).update();
                this.getGrid().refresh();
                this.refreshDecisionComponents();
                return true;
            }
            ((BaseIncludedModelActiveRecord)this.getIncludedModel()).setName(oldName);
            return false;
        };
    }

    protected String getTruncatedSubTitle() {
        return this.truncate(this.getSubTitle(), 60);
    }

    String getSubTitle() {
        if (StringUtils.isEmpty((String)((BaseIncludedModelActiveRecord)this.getIncludedModel()).getPath())) {
            return ((BaseIncludedModelActiveRecord)this.getIncludedModel()).getNamespace();
        }
        return ((BaseIncludedModelActiveRecord)this.getIncludedModel()).getPath();
    }

    String truncate(String value, int limit) {
        if (value.length() > limit) {
            return "..." + value.substring(value.length() - limit);
        }
        return value;
    }

    public void remove() {
        ((ActiveRecord)this.getIncludedModel()).destroy();
        this.getGrid().refresh();
        this.refreshDecisionComponents();
    }

    void refreshDecisionComponents() {
        this.refreshDecisionComponentsEvent.fire((Object)new RefreshDecisionComponents());
    }

    R getIncludedModel() {
        return this.includedModel;
    }

    DMNCardsGridComponent getGrid() {
        return this.grid;
    }

    public static interface ContentView
    extends UberElemental<BaseCardComponent>,
    IsElement {
        public void onRemoveButtonClick(ClickEvent var1);

        public void setPath(String var1);
    }
}

