/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.modal;

import elemental2.dom.HTMLElement;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.editors.included.DMNImportTypes;
import org.kie.workbench.common.dmn.client.api.included.legacy.DMNIncludeModelsClient;
import org.kie.workbench.common.dmn.client.docks.navigator.events.RefreshDecisionComponents;
import org.kie.workbench.common.dmn.client.editors.included.BaseIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.DMNIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.DefaultIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.IncludedModelsPagePresenter;
import org.kie.workbench.common.dmn.client.editors.included.PMMLIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.imports.persistence.ImportRecordEngine;
import org.kie.workbench.common.dmn.client.editors.included.modal.dropdown.DMNAssetsDropdown;
import org.kie.workbench.common.dmn.client.editors.types.common.events.RefreshDataTypesListEvent;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdownItem;
import org.uberfire.ext.editor.commons.client.file.popups.elemental2.Elemental2Modal;
import org.uberfire.mvp.Command;

@Dependent
public class IncludedModelModal
extends Elemental2Modal<View> {
    static final String WIDTH = "600px";
    private final DMNAssetsDropdown dropdown;
    private final ImportRecordEngine recordEngine;
    private final DMNIncludeModelsClient client;
    private final Event<RefreshDataTypesListEvent> refreshDataTypesListEvent;
    private final Event<RefreshDecisionComponents> refreshDecisionComponentsEvent;
    private IncludedModelsPagePresenter grid;

    @Inject
    public IncludedModelModal(View view, DMNAssetsDropdown dropdown, ImportRecordEngine recordEngine, DMNIncludeModelsClient client, Event<RefreshDataTypesListEvent> refreshDataTypesListEvent, Event<RefreshDecisionComponents> refreshDecisionComponentsEvent) {
        super((Elemental2Modal.View)view);
        this.dropdown = dropdown;
        this.recordEngine = recordEngine;
        this.client = client;
        this.refreshDataTypesListEvent = refreshDataTypesListEvent;
        this.refreshDecisionComponentsEvent = refreshDecisionComponentsEvent;
    }

    @PostConstruct
    public void setup() {
        this.superSetup();
        this.setWidth(WIDTH);
        ((View)this.getView()).init((Object)this);
        ((View)this.getView()).setupAssetsDropdown(this.getInitializedDropdownElement());
    }

    public void init(IncludedModelsPagePresenter grid) {
        this.grid = grid;
    }

    public void show() {
        this.getDropdown().loadAssets();
        ((View)this.getView()).initialize();
        ((View)this.getView()).disableIncludeButton();
        this.superShow();
    }

    void superShow() {
        super.show();
    }

    HTMLElement getInitializedDropdownElement() {
        this.getDropdown().initialize();
        this.getDropdown().registerOnChangeHandler(this.getOnValueChanged());
        return this.getDropdown().getElement();
    }

    public void include() {
        this.getDropdown().getValue().ifPresent(value -> {
            BaseIncludedModelActiveRecord includedModel = this.createIncludedModel((KieAssetsDropdownItem)value);
            this.refreshGrid();
            this.refreshDecisionComponents();
            this.refreshDataTypesList(includedModel);
            this.hide();
        });
    }

    void refreshDataTypesList(BaseIncludedModelActiveRecord includedModel) {
        this.client.loadItemDefinitionsByNamespace(includedModel.getName(), includedModel.getNamespace(), this.getItemDefinitionConsumer());
    }

    Consumer<List<ItemDefinition>> getItemDefinitionConsumer() {
        return itemDefinitions -> this.refreshDataTypesListEvent.fire((Object)new RefreshDataTypesListEvent((List<ItemDefinition>)itemDefinitions));
    }

    private void refreshDecisionComponents() {
        this.refreshDecisionComponentsEvent.fire((Object)new RefreshDecisionComponents());
    }

    public void hide() {
        this.superHide();
        this.getDropdown().clear();
    }

    BaseIncludedModelActiveRecord createIncludedModel(KieAssetsDropdownItem value) {
        Map metaData = value.getMetaData();
        BaseIncludedModelActiveRecord includedModel = this.createIncludedModel(metaData);
        includedModel.setName(((View)this.getView()).getModelNameInput());
        includedModel.setNamespace(value.getValue());
        includedModel.setImportType((String)metaData.get("import_type"));
        includedModel.setPath((String)metaData.get("path"));
        includedModel.create();
        return includedModel;
    }

    BaseIncludedModelActiveRecord createIncludedModel(Map<String, String> metaData) {
        String importType = metaData.get("import_type");
        if (Objects.equals(DMNImportTypes.DMN, DMNImportTypes.determineImportType((String)importType))) {
            DMNIncludedModelActiveRecord dmnIncludedModel = new DMNIncludedModelActiveRecord(this.recordEngine);
            dmnIncludedModel.setDrgElementsCount(Integer.valueOf(metaData.get("drg_element_count")));
            dmnIncludedModel.setDataTypesCount(Integer.valueOf(metaData.get("item_definition_count")));
            return dmnIncludedModel;
        }
        if (Objects.equals(DMNImportTypes.PMML, DMNImportTypes.determineImportType((String)importType))) {
            PMMLIncludedModelActiveRecord pmmlIncludedModel = new PMMLIncludedModelActiveRecord(this.recordEngine);
            pmmlIncludedModel.setModelCount(Integer.valueOf(metaData.get("pmml_model_count")));
            return pmmlIncludedModel;
        }
        return new DefaultIncludedModelActiveRecord(this.recordEngine);
    }

    private DMNAssetsDropdown getDropdown() {
        return this.dropdown;
    }

    void superHide() {
        super.hide();
    }

    private Optional<IncludedModelsPagePresenter> getGrid() {
        return Optional.ofNullable(this.grid);
    }

    private void refreshGrid() {
        this.getGrid().ifPresent(IncludedModelsPagePresenter::refresh);
    }

    Command getOnValueChanged() {
        return this::onValueChanged;
    }

    void onValueChanged() {
        if (this.isValidValues()) {
            ((View)this.getView()).enableIncludeButton();
        } else {
            ((View)this.getView()).disableIncludeButton();
        }
    }

    boolean isValidValues() {
        return !StringUtils.isEmpty((String)((View)this.getView()).getModelNameInput()) && this.getDropdown().getValue().isPresent();
    }

    public static interface View
    extends Elemental2Modal.View<IncludedModelModal> {
        public String getModelNameInput();

        public void setupAssetsDropdown(HTMLElement var1);

        public void initialize();

        public void disableIncludeButton();

        public void enableIncludeButton();
    }
}

