/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types;

import java.util.Optional;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.types.CanBeClosedByKeyboard;
import org.kie.workbench.common.dmn.client.editors.types.DataTypePageTabActiveEvent;
import org.kie.workbench.common.dmn.client.editors.types.HasNameAndTypeRef;
import org.kie.workbench.common.dmn.client.editors.types.NameAndDataTypePopoverView;

@ApplicationScoped
public class NameAndDataTypePopoverImpl
implements NameAndDataTypePopoverView.Presenter {
    private NameAndDataTypePopoverView view;
    private Optional<HasNameAndTypeRef> binding = Optional.empty();

    public NameAndDataTypePopoverImpl() {
    }

    @Inject
    public NameAndDataTypePopoverImpl(NameAndDataTypePopoverView view) {
        this.view = view;
        view.init(this);
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    @Override
    public void bind(HasNameAndTypeRef bound, int uiRowIndex, int uiColumnIndex) {
        this.binding = Optional.ofNullable(bound);
        this.refresh();
    }

    private void refresh() {
        this.binding.ifPresent(b -> {
            this.view.setDMNModel(b.asDMNModelInstrumentedBase());
            this.view.initName(b.getName().getValue());
            this.view.initSelectedTypeRef(b.getTypeRef());
        });
    }

    @Override
    public void setName(String name) {
        this.binding.ifPresent(b -> b.setName(new Name(name)));
    }

    @Override
    public void setTypeRef(QName typeRef) {
        this.binding.ifPresent(b -> b.setTypeRef(typeRef));
    }

    @Override
    public void show(Optional<String> editorTitle) {
        this.binding.ifPresent(b -> this.view.show(editorTitle));
    }

    @Override
    public void hide() {
        this.binding.ifPresent(b -> this.view.hide());
    }

    @Override
    public void setOnClosedByKeyboardCallback(Consumer<CanBeClosedByKeyboard> callback) {
        this.view.setOnClosedByKeyboardCallback(callback);
    }

    public void onDataTypePageNavTabActiveEvent(@Observes DataTypePageTabActiveEvent event) {
        this.hide();
    }
}

