/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import elemental2.dom.DomGlobal;
import elemental2.dom.Element;
import elemental2.dom.KeyboardEvent;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.EventListener;
import org.jboss.errai.common.client.dom.Input;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.types.DataTypePickerWidget;
import org.kie.workbench.common.dmn.client.editors.types.NameAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.popover.AbstractPopoverViewImpl;
import org.uberfire.client.views.pfly.selectpicker.JQuerySelectPicker;
import org.uberfire.client.views.pfly.widgets.JQueryProducer;
import org.uberfire.client.views.pfly.widgets.Popover;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@Templated
@ApplicationScoped
public class NameAndDataTypePopoverViewImpl
extends AbstractPopoverViewImpl
implements NameAndDataTypePopoverView {
    static final String TYPE_SELECTOR_BUTTON_SELECTOR = "button.dropdown-toggle.btn-default";
    static final String MANAGE_BUTTON_SELECTOR = "#typeButton";
    static final String TAB_KEY = "Tab";
    static final String ESCAPE_KEY = "Escape";
    static final String ESC_KEY = "Esc";
    static final String ENTER_KEY = "Enter";
    static final String DROPDOWN_ELEMENT_SELECTOR = ".bs-container.btn-group.bootstrap-select.show-tick.input-group-btn";
    @DataField(value="nameEditor")
    private Input nameEditor;
    @DataField(value="typeRefSelector")
    private DataTypePickerWidget typeRefEditor;
    @DataField(value="nameLabel")
    private Span nameLabel;
    @DataField(value="dataTypeLabel")
    private Span dataTypeLabel;
    private NameAndDataTypePopoverView.Presenter presenter;
    private String previousName;
    private String currentName;
    private QName previousTypeRef;
    private QName currentTypeRef;
    private BootstrapSelectDropDownMonitor monitor;
    private Optional<Consumer> closedByKeyboardCallback;

    public void setOnClosedByKeyboardCallback(Consumer callback) {
        this.closedByKeyboardCallback = Optional.ofNullable(callback);
    }

    public void onClosedByKeyboard() {
        this.getClosedByKeyboardCallback().ifPresent(c -> c.accept(this));
    }

    Optional<Consumer> getClosedByKeyboardCallback() {
        return this.closedByKeyboardCallback;
    }

    public NameAndDataTypePopoverViewImpl() {
    }

    @Inject
    public NameAndDataTypePopoverViewImpl(Input nameEditor, DataTypePickerWidget typeRefEditor, Div popoverElement, Div popoverContentElement, Span nameLabel, Span dataTypeLabel, JQueryProducer.JQuery<Popover> jQueryPopover, TranslationService translationService) {
        super(popoverElement, popoverContentElement, jQueryPopover);
        this.nameEditor = nameEditor;
        this.typeRefEditor = typeRefEditor;
        this.popoverElement = popoverElement;
        this.popoverContentElement = popoverContentElement;
        this.nameLabel = nameLabel;
        this.dataTypeLabel = dataTypeLabel;
        this.jQueryPopover = jQueryPopover;
        this.nameLabel.setTextContent(translationService.getTranslation("NameAndDataTypePopover.NameLabel"));
        this.dataTypeLabel.setTextContent(translationService.getTranslation("NameAndDataTypePopover.DataTypeLabel"));
        this.monitor = new BootstrapSelectDropDownMonitor((ParameterizedCommand<Optional<String>>)((ParameterizedCommand)editorTitle -> NameAndDataTypePopoverViewImpl.super.show(editorTitle)), () -> NameAndDataTypePopoverViewImpl.super.hide());
        this.closedByKeyboardCallback = Optional.empty();
    }

    public void init(NameAndDataTypePopoverView.Presenter presenter) {
        this.presenter = presenter;
        this.typeRefEditor.addValueChangeHandler((ValueChangeHandler<QName>)((ValueChangeHandler)e -> {
            this.currentTypeRef = (QName)e.getValue();
        }));
        this.setKeyDownListeners();
    }

    public QName getCurrentTypeRef() {
        return this.currentTypeRef;
    }

    public String getCurrentName() {
        return this.currentName;
    }

    void setKeyDownListeners() {
        this.popoverElement.addEventListener("keydown", this.getKeyDownEventListener(), false);
        Button manageButton = this.getManageButton();
        manageButton.addEventListener("keydown", this.getManageButtonKeyDownEventListener(), false);
        Button typeSelectorButton = this.getTypeSelectorButton();
        typeSelectorButton.addEventListener("keydown", this.getTypeSelectorKeyDownEventListener(), false);
    }

    EventListener getTypeSelectorKeyDownEventListener() {
        return e -> this.typeSelectorKeyDownEventListener(e);
    }

    EventListener getManageButtonKeyDownEventListener() {
        return e -> this.manageButtonKeyDownEventListener(e);
    }

    EventListener getKeyDownEventListener() {
        return e -> this.keyDownEventListener(e);
    }

    Button getTypeSelectorButton() {
        return (Button)this.getElement().querySelector(TYPE_SELECTOR_BUTTON_SELECTOR);
    }

    Button getManageButton() {
        return (Button)this.getElement().querySelector(MANAGE_BUTTON_SELECTOR);
    }

    void typeSelectorKeyDownEventListener(Object event) {
        if (event instanceof KeyboardEvent) {
            KeyboardEvent keyEvent = (KeyboardEvent)event;
            if (this.isEnterKeyPressed(keyEvent)) {
                this.hide(true);
                keyEvent.preventDefault();
                this.onClosedByKeyboard();
            } else if (this.isEscapeKeyPressed(keyEvent)) {
                this.reset();
                this.hide(false);
                this.onClosedByKeyboard();
            } else if (this.isTabKeyPressed(keyEvent)) {
                if (keyEvent.shiftKey) {
                    Button manageButton = this.getManageButton();
                    manageButton.focus();
                } else {
                    this.nameEditor.focus();
                }
                keyEvent.preventDefault();
            }
        }
    }

    void manageButtonKeyDownEventListener(Object event) {
        KeyboardEvent keyEvent;
        if (event instanceof KeyboardEvent && this.isEscapeKeyPressed(keyEvent = (KeyboardEvent)event)) {
            this.reset();
            this.hide(false);
            this.onClosedByKeyboard();
        }
    }

    void keyDownEventListener(Object event) {
        if (event instanceof KeyboardEvent) {
            KeyboardEvent keyEvent = (KeyboardEvent)event;
            if (this.isEnterKeyPressed(keyEvent)) {
                this.hide(true);
                keyEvent.stopPropagation();
                this.onClosedByKeyboard();
            } else if (this.isEscapeKeyPressed(keyEvent)) {
                this.reset();
                this.hide(false);
                this.onClosedByKeyboard();
            }
        }
    }

    boolean isTabKeyPressed(KeyboardEvent event) {
        return Objects.equals(event.key, TAB_KEY);
    }

    boolean isEscapeKeyPressed(KeyboardEvent event) {
        return Objects.equals(event.key, ESC_KEY) || Objects.equals(event.key, ESCAPE_KEY);
    }

    boolean isEnterKeyPressed(KeyboardEvent event) {
        return Objects.equals(event.key, ENTER_KEY);
    }

    @Override
    public void setDMNModel(DMNModelInstrumentedBase dmnModel) {
        this.typeRefEditor.setDMNModel(dmnModel);
        this.previousTypeRef = this.typeRefEditor.getValue();
    }

    @Override
    public void initName(String name) {
        this.nameEditor.setValue(name);
        this.previousName = name;
        this.currentName = name;
    }

    @Override
    public void initSelectedTypeRef(QName typeRef) {
        this.typeRefEditor.setValue(typeRef, false);
    }

    @Override
    public void show(Optional<String> editorTitle) {
        this.getMonitor().show(editorTitle);
        this.nameEditor.focus();
    }

    @Override
    public void hide() {
        this.hide(true);
    }

    public void hide(boolean applyChanges) {
        this.nameEditor.blur();
        this.getMonitor().hide();
        if (applyChanges) {
            this.applyChanges();
        }
    }

    BootstrapSelectDropDownMonitor getMonitor() {
        return this.monitor;
    }

    @EventHandler(value={"nameEditor"})
    void onNameChange(BlurEvent event) {
        this.currentName = this.nameEditor.getValue();
    }

    void applyChanges() {
        this.presenter.setName(this.currentName);
        if (!Objects.isNull(this.currentTypeRef)) {
            this.presenter.setTypeRef(this.currentTypeRef);
        }
    }

    void reset() {
        this.nameEditor.setValue(this.previousName);
        if (!Objects.isNull(this.previousTypeRef)) {
            this.typeRefEditor.setValue(this.previousTypeRef);
        }
        this.currentName = this.previousName;
        this.previousTypeRef = null;
        this.currentTypeRef = null;
    }

    @EventHandler(value={"nameEditor"})
    public void onNameEditorKeyDown(KeyDownEvent event) {
        if (this.isEnter(event)) {
            this.hide(true);
            this.onClosedByKeyboard();
        } else if (this.isEsc(event)) {
            this.reset();
            this.hide(false);
            this.onClosedByKeyboard();
        } else if (event.isShiftKeyDown() && this.isTab(event)) {
            Button typeSelectorButton = this.getTypeSelectorButton();
            typeSelectorButton.focus();
            event.preventDefault();
        }
    }

    boolean isTab(KeyDownEvent event) {
        return Objects.equals(event.getNativeKeyCode(), 9);
    }

    boolean isEsc(KeyDownEvent event) {
        return Objects.equals(event.getNativeKeyCode(), 27);
    }

    boolean isEnter(KeyDownEvent event) {
        return Objects.equals(event.getNativeKeyCode(), 13);
    }

    static class BootstrapSelectDropDownMonitor {
        static final String SELECT_ID = "#kieDataType";
        static final String BOOTSTRAP_SELECT_SHOWN_EVENT = "shown.bs.select";
        static final String BOOTSTRAP_SELECT_HIDDEN_EVENT = "hidden.bs.select";
        static final String OPEN_CLASS = "open";
        private final ParameterizedCommand<Optional<String>> commandShow;
        private final Command commandHide;

        BootstrapSelectDropDownMonitor(ParameterizedCommand<Optional<String>> commandShow, Command commandHide) {
            this.commandShow = commandShow;
            this.commandHide = commandHide;
        }

        void show(Optional<String> editorTitle) {
            this.commandShow.execute(editorTitle);
        }

        void hide() {
            this.kieDataTypeSelect().off(BOOTSTRAP_SELECT_SHOWN_EVENT);
            if (this.isVisible()) {
                this.kieDataTypeSelect().on(BOOTSTRAP_SELECT_HIDDEN_EVENT, event -> this.onHide());
            } else {
                this.onHide();
            }
        }

        void onHide() {
            this.kieDataTypeSelect().off(BOOTSTRAP_SELECT_HIDDEN_EVENT);
            this.commandHide.execute();
        }

        boolean isVisible() {
            Element menuElement = this.getMenuElement();
            return Optional.ofNullable(menuElement).map(element -> element.classList.contains(OPEN_CLASS)).orElse(false);
        }

        Element getMenuElement() {
            return DomGlobal.document.querySelector(NameAndDataTypePopoverViewImpl.DROPDOWN_ELEMENT_SELECTOR);
        }

        JQuerySelectPicker kieDataTypeSelect() {
            return JQuerySelectPicker.$((String)SELECT_ID);
        }
    }
}

