/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common;

import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.api.editors.types.BuiltInTypeUtils;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.stunner.core.util.StringUtils;

@Dependent
public class ConstraintPlaceholderHelper {
    private static final String CONSTRAINT_PLACEHOLDER_SENTENCE_PREFIX = "ConstraintPlaceholderHelper.Sentence";
    private static final String CONSTRAINT_PLACEHOLDER_SAMPLE_PREFIX = "ConstraintPlaceholderHelper.Sample";
    private final TranslationService translationService;

    @Inject
    public ConstraintPlaceholderHelper(TranslationService translationService) {
        this.translationService = translationService;
    }

    public String getPlaceholderSentence(String type) {
        String sentence = this.getTranslation(type, CONSTRAINT_PLACEHOLDER_SENTENCE_PREFIX);
        return !StringUtils.isEmpty((String)sentence) ? sentence : this.defaultSentence();
    }

    public String getPlaceholderSample(String type) {
        String sentence = this.getTranslation(type, CONSTRAINT_PLACEHOLDER_SAMPLE_PREFIX);
        return !StringUtils.isEmpty((String)sentence) ? sentence : this.defaultSample();
    }

    private String getTranslation(String type, String prefix) {
        Optional builtInType = BuiltInTypeUtils.findBuiltInTypeByName((String)type);
        String i18nKey = prefix + builtInType.map(this::builtInTypeAsKey).orElse("");
        return this.translationService.getTranslation(i18nKey);
    }

    private String builtInTypeAsKey(BuiltInType builtInType) {
        String[] names = builtInType.getNames();
        String name = names[names.length - 1];
        return this.capitalize(name);
    }

    private String capitalize(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private String defaultSentence() {
        return this.translationService.format("ConstraintPlaceholderHelper.SentenceDefault", new Object[0]);
    }

    private String defaultSample() {
        return this.translationService.format("ConstraintPlaceholderHelper.SampleDefault", new Object[0]);
    }
}

