/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time.picker;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.editors.types.DMNSimpleTimeZone;
import org.kie.workbench.common.dmn.client.service.DMNClientServicesProxy;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;

@ApplicationScoped
public class TimeZoneProvider {
    private final DMNClientServicesProxy clientServicesProxy;
    private final List<DMNSimpleTimeZone> timeZones;
    private final List<String> timeZonesOffsets;

    @Inject
    public TimeZoneProvider(DMNClientServicesProxy clientServicesProxy) {
        this.clientServicesProxy = clientServicesProxy;
        this.timeZones = new ArrayList<DMNSimpleTimeZone>();
        this.timeZonesOffsets = new ArrayList<String>();
    }

    public void getTimeZones(final Consumer<List<DMNSimpleTimeZone>> consumer) {
        if (this.getLoadedTimeZones().isEmpty()) {
            this.clientServicesProxy.getTimeZones(new ServiceCallback<List<DMNSimpleTimeZone>>(){

                public void onSuccess(List<DMNSimpleTimeZone> timeZones) {
                    TimeZoneProvider.this.getLoadedTimeZones().clear();
                    TimeZoneProvider.this.getLoadedTimeZones().addAll(timeZones);
                    DMNSimpleTimeZone[] offSets = (DMNSimpleTimeZone[])timeZones.stream().sorted(Comparator.comparingDouble(DMNSimpleTimeZone::getOffset)).toArray(DMNSimpleTimeZone[]::new);
                    TimeZoneProvider.this.getTimeZonesOffsets().clear();
                    for (DMNSimpleTimeZone offSet : offSets) {
                        String offsetString = offSet.getOffsetString();
                        if (TimeZoneProvider.this.getTimeZonesOffsets().contains(offsetString)) continue;
                        TimeZoneProvider.this.getTimeZonesOffsets().add(offsetString);
                    }
                    consumer.accept(timeZones);
                }

                public void onError(ClientRuntimeError error) {
                    TimeZoneProvider.this.clientServicesProxy.logWarning(error);
                }
            });
        } else {
            consumer.accept(this.getLoadedTimeZones());
        }
    }

    public boolean isTimeZone(String timeZone) {
        if ("UTC".equals(timeZone)) {
            return false;
        }
        return this.getLoadedTimeZones().stream().anyMatch(s -> s.getId().equals(timeZone));
    }

    public List<String> getTimeZonesOffsets() {
        return this.timeZonesOffsets;
    }

    List<DMNSimpleTimeZone> getLoadedTimeZones() {
        return this.timeZones;
    }
}

