/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop;

import elemental2.dom.DomGlobal;
import elemental2.dom.Element;
import java.util.Optional;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeList;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDDataTypesHandlerContext;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDDataTypesHandlerShiftStrategy;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDListComponent;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionStore;

public class DNDDataTypesHandler {
    private final DataTypeStore dataTypeStore;
    private final DataTypeManager dataTypeManager;
    private final ItemDefinitionStore itemDefinitionStore;
    private DataTypeList dataTypeList;

    @Inject
    public DNDDataTypesHandler(DataTypeStore dataTypeStore, DataTypeManager dataTypeManager, ItemDefinitionStore itemDefinitionStore) {
        this.dataTypeStore = dataTypeStore;
        this.dataTypeManager = dataTypeManager;
        this.itemDefinitionStore = itemDefinitionStore;
    }

    public void init(DataTypeList dataTypeList) {
        this.dataTypeList = dataTypeList;
    }

    public void onDropDataType(Element currentElement, Element hoverElement) {
        try {
            DNDDataTypesHandlerContext dndContext = this.makeDndContext(currentElement, hoverElement);
            Optional<DataType> current = dndContext.getCurrentDataType();
            Optional<DataType> reference = dndContext.getReference();
            if (current.isPresent() && reference.isPresent()) {
                this.shiftCurrentByReference(current.get(), reference.get(), dndContext.getStrategy());
            }
        }
        catch (Exception e) {
            this.logError("Drag-n-Drop error (" + e.getMessage() + "). Check '" + DNDDataTypesHandler.class.getSimpleName() + "'.");
        }
    }

    void shiftCurrentByReference(DataType current, DataType reference, DNDDataTypesHandlerShiftStrategy shiftStrategy) {
        String referenceHash = this.getDataTypeList().calculateHash(reference);
        DataType clone = this.cloneDataType(current);
        Optional<DataTypeListItem> currentItem = this.getDataTypeList().findItem(current);
        boolean isCurrentItemCollapsed = currentItem.map(DataTypeListItem::isCollapsed).orElse(false);
        currentItem.ifPresent(item -> {
            if (this.isTopLevelShiftOperation(current, shiftStrategy)) {
                item.destroyWithoutDependentTypes();
            } else {
                item.destroyWithDependentTypes();
            }
        });
        this.getDataTypeList().findItemByDataTypeHash(referenceHash).ifPresent(ref -> shiftStrategy.getConsumer().accept((DataTypeListItem)ref, clone));
        this.getDataTypeList().findItem(clone).ifPresent(item -> {
            if (isCurrentItemCollapsed) {
                item.collapse();
            } else {
                item.expand();
            }
        });
    }

    public void deleteKeepingReferences(DataType existing) {
        Optional<DataTypeListItem> currentItem = this.getDataTypeList().findItem(existing);
        currentItem.ifPresent(item -> item.destroyWithoutDependentTypes());
    }

    boolean isTopLevelShiftOperation(DataType dataType, DNDDataTypesHandlerShiftStrategy shiftStrategy) {
        boolean isCurrentTopLevel = dataType.isTopLevel();
        boolean isTopLevelShiftStrategy = shiftStrategy == DNDDataTypesHandlerShiftStrategy.INSERT_TOP_LEVEL_DATA_TYPE_AT_THE_TOP || shiftStrategy == DNDDataTypesHandlerShiftStrategy.INSERT_TOP_LEVEL_DATA_TYPE;
        return isCurrentTopLevel && isTopLevelShiftStrategy;
    }

    DataType cloneDataType(DataType current) {
        String currentUUID = current.getUUID();
        ItemDefinition itemDefinition = this.itemDefinitionStore.get(currentUUID);
        return this.dataTypeManager.from(itemDefinition).get();
    }

    DNDDataTypesHandlerContext makeDndContext(Element currentElement, Element hoverElement) {
        return new DNDDataTypesHandlerContext(this, currentElement, hoverElement);
    }

    private DataTypeList getDataTypeList() {
        return Optional.ofNullable(this.dataTypeList).orElseThrow(() -> {
            String errorMessage = "'DNDDataTypesHandler' must be initialized with a 'DataTypeList' instance.";
            return new UnsupportedOperationException("'DNDDataTypesHandler' must be initialized with a 'DataTypeList' instance.");
        });
    }

    DataTypeStore getDataTypeStore() {
        return this.dataTypeStore;
    }

    DNDListComponent getDndListComponent() {
        return Optional.ofNullable(this.getDataTypeList().getDNDListComponent()).orElseThrow(() -> {
            String errorMessage = "'DNDDataTypesHandler' must be initialized with a 'DNDListComponent' instance.";
            return new UnsupportedOperationException("'DNDDataTypesHandler' must be initialized with a 'DNDListComponent' instance.");
        });
    }

    void logError(String message) {
        DomGlobal.console.error(new Object[]{message});
    }
}

