/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop;

import elemental2.dom.Element;
import elemental2.dom.Event;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.MouseEvent;
import elemental2.dom.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.client.editors.common.RemoveHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDListComponent;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDListDOMHelper;

@Templated
public class DNDListComponentView
implements DNDListComponent.View {
    @DataField(value="drag-area")
    private final HTMLDivElement dragArea;
    private List<HTMLElement> dependentElements = Collections.emptyList();
    private HTMLElement dragging;
    private DNDListComponent presenter;

    @Inject
    public DNDListComponentView(HTMLDivElement dragArea) {
        this.dragArea = dragArea;
    }

    public void init(DNDListComponent presenter) {
        this.presenter = presenter;
        this.setupDragAreaHandlers();
    }

    @Override
    public HTMLElement registerItem(HTMLElement htmlElement) {
        HTMLElement item = this.createItem(htmlElement);
        DNDListDOMHelper.Position.setY((Element)item, (double)this.getMaxPositionY() + 1.0);
        DNDListDOMHelper.Position.setX((Element)item, 0.0);
        this.getDragArea().appendChild((Node)item);
        return item;
    }

    @Override
    public void refreshItemsPosition() {
        for (HTMLElement draggable : DNDListDOMHelper.querySelector((Element)this.getDragArea()).getVisibleDraggableElements()) {
            int positionY = DNDListDOMHelper.Position.getY((Element)draggable);
            int positionX = DNDListDOMHelper.Position.getX((Element)draggable);
            int top = positionY * this.getItemHeight();
            int margin = positionX * this.getLevelSize();
            DNDListDOMHelper.setCSSTop(draggable, top);
            DNDListDOMHelper.setCSSPaddingLeft(draggable, margin);
            DNDListDOMHelper.setCSSWidth(draggable, 0);
        }
        this.refreshDragAreaSize();
    }

    @Override
    public void refreshItemsHTML() {
        List<HTMLElement> draggableElements = DNDListDOMHelper.querySelector((Element)this.getDragArea()).getSortedDraggableElements();
        RemoveHelper.removeChildren((Element)this.getDragArea());
        draggableElements.forEach(arg_0 -> ((HTMLDivElement)this.getDragArea()).appendChild(arg_0));
    }

    @Override
    public void consolidateHierarchicalLevel(boolean isElementsDraggedByUser) {
        List<HTMLElement> draggableElements = DNDListDOMHelper.querySelector((Element)this.getDragArea()).getVisibleAndSortedDraggableElements();
        if (isElementsDraggedByUser && !draggableElements.isEmpty()) {
            DNDListDOMHelper.Position.setX((Element)draggableElements.get(0), 0.0);
        }
        if (draggableElements.size() < 2) {
            return;
        }
        for (int i = 0; i < draggableElements.size() - 1; ++i) {
            HTMLElement current = draggableElements.get(i);
            HTMLElement next = draggableElements.get(i + 1);
            int currentXPosition = DNDListDOMHelper.Position.getX((Element)current);
            int minimalLevel = currentXPosition + 1;
            int nextElementLevel = DNDListDOMHelper.Position.getX((Element)next);
            int numberOfExtraLevels = nextElementLevel - minimalLevel;
            if (nextElementLevel > minimalLevel) {
                this.fixChildrenPosition(minimalLevel, numberOfExtraLevels, this.getDependentElements(current));
            }
            DNDListDOMHelper.Position.setY((Element)current, i);
            DNDListDOMHelper.Position.setY((Element)next, (double)i + 1.0);
        }
    }

    @Override
    public void consolidateYPosition() {
        List<HTMLElement> draggableElements = DNDListDOMHelper.querySelector((Element)this.getDragArea()).getVisibleDraggableElements();
        for (int i = 0; i < draggableElements.size(); ++i) {
            DNDListDOMHelper.Position.setY((Element)draggableElements.get(i), i);
        }
    }

    @Override
    public void clear() {
        RemoveHelper.removeChildren((Element)this.getDragArea());
    }

    @Override
    public Optional<HTMLElement> getPreviousElement(Element reference) {
        int positionY = DNDListDOMHelper.Position.getY(reference);
        return DNDListDOMHelper.querySelector((Element)this.getDragArea()).getDraggableElement(positionY - 1);
    }

    void setupDragAreaHandlers() {
        this.getDragArea().onmousedown = e -> {
            this.onStartDrag(e);
            return true;
        };
        this.getDragArea().onmousemove = e -> {
            this.onDrag(e);
            return true;
        };
        this.getDragArea().onmouseup = e -> {
            this.onDrop();
            return true;
        };
        this.getDragArea().onmouseout = e -> {
            this.onDrop();
            return true;
        };
    }

    void onStartDrag(Event event) {
        HTMLElement target = (HTMLElement)event.target;
        HTMLElement parent = (HTMLElement)target.parentNode;
        if (DNDListDOMHelper.isGrip(target)) {
            this.holdDraggingElement(parent);
        }
    }

    void onDrag(Event event) {
        if (this.isNotDragging()) {
            return;
        }
        this.updateDraggingElementY(event);
        this.updateDraggingElementX(event);
        this.updateHoverElement();
        this.updateDependentsPosition();
    }

    void onDrop() {
        if (this.isNotDragging()) {
            return;
        }
        this.updateDraggingElementsPosition();
        this.executeOnDropItemCallback();
        this.releaseDraggingElement();
        this.consolidateHierarchicalLevel(true);
        this.refreshItemsPosition();
        this.refreshItemsHTML();
        this.clearHover();
    }

    void updateDraggingElementsPosition() {
        HTMLElement draggingElement = this.getDragging();
        Optional<HTMLElement> previousElement = this.getPreviousElement((Element)draggingElement);
        boolean hasChildren = previousElement.map(this::hasChildren).orElse(false);
        int currentXPosition = this.getCurrentXPosition(draggingElement);
        double numberOfExtraLevels = hasChildren ? 1.0 : 0.0;
        DNDListDOMHelper.Position.setX((Element)draggingElement, (double)currentXPosition + numberOfExtraLevels);
        this.getDependentElements().forEach(el -> DNDListDOMHelper.Position.setX((Element)el, numberOfExtraLevels + (double)this.getCurrentXPosition((HTMLElement)el)));
    }

    int getMaxPositionY() {
        return DNDListDOMHelper.querySelector((Element)this.getDragArea()).getDraggableElements().stream().mapToInt(DNDListDOMHelper.Position::getY).max().orElse(-1);
    }

    private int getCurrentXPosition(HTMLElement element) {
        int margin = DNDListDOMHelper.getCSSWidth(element) / this.getLevelSize();
        return margin > 0 ? margin : 0;
    }

    void executeOnDropItemCallback() {
        Optional<HTMLElement> hoverElement = DNDListDOMHelper.querySelector((Element)this.getDragArea()).getHoverElement();
        hoverElement.ifPresent(hover -> {
            int currentXPosition = DNDListDOMHelper.Position.getX((Element)hover);
            int minimalLevel = currentXPosition + 1;
            int numberOfExtraLevels = DNDListDOMHelper.Position.getX((Element)this.getDragging()) - minimalLevel;
            ArrayList<HTMLElement> children = new ArrayList<HTMLElement>(this.getDependentElements());
            children.add(this.getDragging());
            DNDListDOMHelper.Position.setX((Element)this.getDragging(), (double)currentXPosition + 1.0);
            this.fixChildrenPosition(minimalLevel, numberOfExtraLevels, children);
        });
        this.presenter.executeOnDropItemCallback((Element)this.getDragging(), hoverElement.orElse(null));
    }

    private int getDraggingYCoordinate() {
        return (int)(this.getDragging().offsetTop + (double)this.getItemHeight() / 2.0);
    }

    void hover(int hoverPosition) {
        Optional<HTMLElement> hoverElement = DNDListDOMHelper.querySelector((Element)this.getDragArea()).getDraggableElement(hoverPosition);
        this.clearHover();
        hoverElement.ifPresent(hover -> {
            boolean isNotDragging;
            boolean bl = isNotDragging = !DNDListDOMHelper.isDraggingElement(hover);
            if (isNotDragging) {
                DNDListDOMHelper.asHover(hover);
            }
        });
    }

    void clearHover() {
        DNDListDOMHelper.querySelector((Element)this.getDragArea()).getHoverElement().ifPresent(DNDListDOMHelper::asNonHover);
    }

    void updateDependentsPosition() {
        List elements = Optional.ofNullable(this.getDependentElements()).orElse(Collections.emptyList());
        for (int i = 0; i < elements.size(); ++i) {
            HTMLElement dependent = (HTMLElement)elements.get(i);
            int dependentTop = DNDListDOMHelper.getCSSTop(this.getDragging()) + this.getItemHeight() * (i + 1);
            DNDListDOMHelper.setCSSTop(dependent, dependentTop);
            DNDListDOMHelper.setCSSWidth(dependent, DNDListDOMHelper.getCSSWidth(this.getDragging()));
        }
    }

    boolean hasChildren(Element element) {
        int nextPositionX;
        Element next = this.getNextElement(element, nextElement -> {
            boolean isNotDragging = !Objects.equals(nextElement, this.getDragging());
            boolean isNotDependentElement = !this.getDependentElements().contains(nextElement);
            return isNotDragging && isNotDependentElement;
        });
        if (next == null) {
            return false;
        }
        int currentPositionX = DNDListDOMHelper.Position.getX(element);
        return currentPositionX == (nextPositionX = DNDListDOMHelper.Position.getX(next).intValue()) - 1;
    }

    private Element getNextElement(Element element, Function<HTMLElement, Boolean> function) {
        int nextElementPosition = DNDListDOMHelper.Position.getY(element) + 1;
        HTMLElement next = DNDListDOMHelper.querySelector((Element)this.getDragArea()).getDraggableElement(nextElementPosition).orElse(null);
        if (function.apply(next).booleanValue() || next == null) {
            return next;
        }
        return this.getNextElement((Element)next, function);
    }

    @Override
    public void refreshDragAreaSize() {
        int numberOfElements = DNDListDOMHelper.querySelector((Element)this.getDragArea()).getVisibleDraggableElements().size();
        boolean border = true;
        int elementHeight = this.getItemHeight();
        int height = numberOfElements * elementHeight + 1;
        this.getDragArea().style.setProperty("height", height + "px");
    }

    void fixChildrenPosition(int minimalXPosition, int numberOfExtraLevels, List<HTMLElement> children) {
        for (int i = 0; i < children.size(); ++i) {
            boolean isElementPositionValid;
            HTMLElement dependentElement = children.get(i);
            int elementPosition = DNDListDOMHelper.Position.getX((Element)dependentElement);
            boolean bl = isElementPositionValid = i > 0 && elementPosition >= DNDListDOMHelper.Position.getX((Element)children.get(i - 1));
            if (isElementPositionValid) continue;
            int positionX = elementPosition - numberOfExtraLevels;
            int newElementPosition = positionX < minimalXPosition ? minimalXPosition : positionX;
            DNDListDOMHelper.Position.setX((Element)dependentElement, newElementPosition);
        }
    }

    private DNDMinMaxTuple getMinMaxDraggingYCoordinates() {
        int draggingYCoordinate = this.getDraggingYCoordinate();
        int padding = this.getDragPadding();
        int max = (draggingYCoordinate + padding) / this.getItemHeight();
        int min = (draggingYCoordinate - padding) / this.getItemHeight();
        return new DNDMinMaxTuple(max, min);
    }

    void updateHoverElement() {
        int draggingYPosition = DNDListDOMHelper.Position.getY((Element)this.getDragging());
        int hoverPosition = this.getDraggingYCoordinate() / this.getItemHeight();
        DNDMinMaxTuple minMaxTuple = this.getMinMaxDraggingYCoordinates();
        if (draggingYPosition < minMaxTuple.max || draggingYPosition > minMaxTuple.min) {
            this.hover(hoverPosition);
        }
    }

    void updateDraggingElementY(Event event) {
        int draggingYPosition = DNDListDOMHelper.Position.getY((Element)this.getDragging());
        int mouseYPosition = this.getDraggingYCoordinate() / this.getItemHeight();
        DNDMinMaxTuple minMaxTuple = this.getMinMaxDraggingYCoordinates();
        if (draggingYPosition < minMaxTuple.min) {
            this.updateDraggingElementY(mouseYPosition, draggingYPosition, mouseYPosition + this.getDependentElements().size());
        }
        if (draggingYPosition > minMaxTuple.max) {
            this.updateDraggingElementY(mouseYPosition, mouseYPosition + this.getDependentElements().size() + 1, mouseYPosition);
        }
        DNDListDOMHelper.setCSSTop(this.getDragging(), this.getNewDraggingYPosition(event));
    }

    void updateDraggingElementX(Event event) {
        DNDListDOMHelper.setCSSWidth(this.getDragging(), this.getNewDraggingXPosition(event));
    }

    private void updateDraggingElementY(int mouseYPosition, int newSiblingYPosition, int oldSiblingYPosition) {
        Optional<HTMLElement> draggableElement = DNDListDOMHelper.querySelector((Element)this.getDragArea()).getDraggableElement(oldSiblingYPosition);
        draggableElement.ifPresent(siblingElement -> {
            DNDListDOMHelper.Position.setY((Element)siblingElement, newSiblingYPosition);
            DNDListDOMHelper.Position.setY((Element)this.getDragging(), mouseYPosition);
            this.clearHover();
            for (int i = 0; i < this.getDependentElements().size(); ++i) {
                DNDListDOMHelper.Position.setY((Element)this.getDependentElements().get(i), (double)(mouseYPosition + i) + 1.0);
            }
            this.refreshItemsPosition();
        });
    }

    int getNewDraggingYPosition(Event event) {
        Double absoluteMouseY = this.getAbsoluteMouseY(event);
        Double newYPosition = absoluteMouseY - (double)this.getItemHeight() / 2.0;
        Double maxYPosition = this.getDragAreaY() + this.getDragArea().offsetHeight;
        if (newYPosition > maxYPosition) {
            return maxYPosition.intValue();
        }
        return newYPosition.intValue();
    }

    private int getNewDraggingXPosition(Event event) {
        int padding = 10;
        double absoluteMouseX = this.getAbsoluteMouseX(event);
        int newXPosition = (int)absoluteMouseX - 10;
        int maxXPosition = this.getItemWidth() - this.getLevelSize();
        if (newXPosition < 0) {
            return 0;
        }
        if (newXPosition > maxXPosition) {
            return maxXPosition;
        }
        return newXPosition;
    }

    boolean isNotDragging() {
        return !Optional.ofNullable(this.getDragging()).isPresent();
    }

    private double getAbsoluteMouseX(Event event) {
        MouseEvent mouseEvent = (MouseEvent)event;
        return mouseEvent.x - this.getDragAreaX();
    }

    private double getAbsoluteMouseY(Event event) {
        MouseEvent mouseEvent = (MouseEvent)event;
        return mouseEvent.y - this.getDragAreaY();
    }

    void holdDraggingElement(HTMLElement element) {
        this.setDragging(element);
        this.setDependentElements(this.getDependentElements(element));
        DNDListDOMHelper.asDragging(this.getDragging());
        this.getDependentElements().forEach(DNDListDOMHelper::asDragging);
    }

    void releaseDraggingElement() {
        DNDListDOMHelper.asNonDragging(this.getDragging());
        this.getDependentElements().forEach(DNDListDOMHelper::asNonDragging);
        this.setDependentElements(Collections.emptyList());
        this.setDragging(null);
    }

    List<HTMLElement> getDependentElements(HTMLElement element) {
        int minimalLevel = DNDListDOMHelper.Position.getX((Element)element) + 1;
        ArrayList<HTMLElement> initial = new ArrayList<HTMLElement>();
        return this.getNextDependents(initial, (Element)element, minimalLevel);
    }

    private List<HTMLElement> getNextDependents(List<HTMLElement> dependents, Element element, int minimalLevel) {
        int positionY = DNDListDOMHelper.Position.getY(element);
        HTMLElement next = DNDListDOMHelper.querySelector((Element)this.getDragArea()).getDraggableElement(positionY + 1).orElse(null);
        if (next == null || DNDListDOMHelper.Position.getX((Element)next) < minimalLevel) {
            return dependents;
        }
        dependents.add(next);
        return this.getNextDependents(dependents, (Element)next, minimalLevel);
    }

    private int getItemWidth() {
        return (int)this.getDragArea().offsetWidth;
    }

    private double getDragAreaY() {
        return this.getDragArea().getBoundingClientRect().top;
    }

    private double getDragAreaX() {
        return this.getDragArea().getBoundingClientRect().left;
    }

    private int getLevelSize() {
        return this.presenter.getIndentationSize();
    }

    private int getItemHeight() {
        return this.presenter.getItemHeight();
    }

    private int getDragPadding() {
        return this.getItemHeight() / 3;
    }

    HTMLElement createItem(HTMLElement htmlElement) {
        HTMLElement item = DNDListDOMHelper.Factory.createDiv();
        HTMLElement gripElement = DNDListDOMHelper.Factory.createGripElement();
        item.appendChild((Node)gripElement);
        item.appendChild((Node)htmlElement);
        return DNDListDOMHelper.asDraggable(item);
    }

    HTMLElement getDragging() {
        return this.dragging;
    }

    List<HTMLElement> getDependentElements() {
        return this.dependentElements;
    }

    @Override
    public HTMLDivElement getDragArea() {
        return this.dragArea;
    }

    private void setDependentElements(List<HTMLElement> dependentElements) {
        this.dependentElements = dependentElements;
    }

    private void setDragging(HTMLElement dragging) {
        this.dragging = dragging;
    }

    private class DNDMinMaxTuple {
        private final int min;
        private final int max;

        DNDMinMaxTuple(int max, int min) {
            this.max = max;
            this.min = min;
        }
    }
}

