/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop;

import elemental2.dom.DomGlobal;
import elemental2.dom.Element;
import elemental2.dom.HTMLDocument;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import elemental2.dom.NodeList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

class DNDListDOMHelper {
    static final String DRAGGABLE = "kie-dnd-draggable";
    static final String DRAGGING = "kie-dnd-current-dragging";
    static final String HOVER = "kie-dnd-hover";
    static final String GRIP = "kie-dnd-grip";
    static final String DATA_Y_POSITION = "data-y-position";
    static final int HIDDEN_Y_POSITION = -1;
    static final String DATA_X_POSITION = "data-x-position";

    DNDListDOMHelper() {
    }

    static QuerySelector querySelector(Element container) {
        return new QuerySelector(container);
    }

    static void setCSSTop(HTMLElement element, int value) {
        element.style.setProperty("top", value + "px");
    }

    static void setCSSPaddingLeft(HTMLElement element, int value) {
        element.style.setProperty("padding-left", value + "px");
    }

    static void setCSSWidth(HTMLElement element, int value) {
        element.style.setProperty("width", "calc(100% - " + value + "px)");
    }

    static int getCSSTop(HTMLElement element) {
        return DNDListDOMHelper.parseInt(element.style.getPropertyValue("top"));
    }

    static int getCSSWidth(HTMLElement element) {
        String width = element.style.getPropertyValue("width");
        return DNDListDOMHelper.parseInt(width.replace("calc(100% - ", "").replace("px)", ""));
    }

    static HTMLElement asHover(HTMLElement element) {
        element.classList.add(new String[]{HOVER});
        return element;
    }

    static HTMLElement asNonHover(HTMLElement element) {
        element.classList.remove(new String[]{HOVER});
        return element;
    }

    static HTMLElement asDragging(HTMLElement element) {
        element.classList.add(new String[]{DRAGGING});
        return element;
    }

    static HTMLElement asNonDragging(HTMLElement element) {
        element.classList.remove(new String[]{DRAGGING});
        return element;
    }

    static HTMLElement asDraggable(HTMLElement element) {
        element.classList.add(new String[]{DRAGGABLE});
        return element;
    }

    static boolean isDraggingElement(HTMLElement element) {
        return element.classList.contains(DRAGGING);
    }

    static boolean isGrip(HTMLElement element) {
        return element.classList.contains(GRIP);
    }

    static Integer parseInt(String value) {
        return DNDListDOMHelper.parseDouble(value).intValue();
    }

    static Double parseDouble(String value) {
        try {
            return Double.valueOf(DNDListDOMHelper.withoutPX(value));
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    private static String withoutPX(String value) {
        return Optional.ofNullable(value).map(e -> e.replaceAll("px", "")).orElse("");
    }

    static class Factory {
        static final String ICON_CLASS = "fa";
        static final String ELLIPSIS_CLASS = "fa-ellipsis-v";
        static HTMLDocument DOCUMENT = DomGlobal.document;

        Factory() {
        }

        static HTMLElement createGripElement() {
            HTMLElement grip = Factory.createDiv();
            grip.classList.add(new String[]{DNDListDOMHelper.GRIP});
            grip.appendChild((Node)Factory.createEllipsisElement());
            grip.appendChild((Node)Factory.createEllipsisElement());
            return grip;
        }

        static HTMLElement createDiv() {
            return Factory.createElement("div");
        }

        private static HTMLElement createEllipsisElement() {
            HTMLElement i = Factory.createElement("i");
            i.classList.add(new String[]{ICON_CLASS});
            i.classList.add(new String[]{ELLIPSIS_CLASS});
            return i;
        }

        private static HTMLElement createElement(String tagName) {
            return (HTMLElement)DOCUMENT.createElement(tagName);
        }
    }

    static class QuerySelector {
        private final Element container;

        QuerySelector(Element container) {
            this.container = container;
        }

        Optional<HTMLElement> getDraggableElement(int yPosition) {
            String selector = ".kie-dnd-draggable[data-y-position=\"" + yPosition + "\"]";
            return Optional.ofNullable(this.container.querySelector(selector)).map(e -> (HTMLElement)e);
        }

        Optional<HTMLElement> getHoverElement() {
            String selector = ".kie-dnd-hover";
            return Optional.ofNullable(this.container.querySelector(".kie-dnd-hover")).map(e -> (HTMLElement)e);
        }

        List<HTMLElement> getDraggableElements() {
            String selector = ".kie-dnd-draggable";
            return this.asList((NodeList<Element>)this.container.querySelectorAll(".kie-dnd-draggable"));
        }

        List<HTMLElement> getSortedDraggableElements() {
            return this.getDraggableElements().stream().sorted(Comparator.comparing(Position::getDoubleY)).collect(Collectors.toList());
        }

        List<HTMLElement> getVisibleDraggableElements() {
            return this.getDraggableElements().stream().filter(e -> Position.getY((Element)e) > -1).collect(Collectors.toList());
        }

        List<HTMLElement> getVisibleAndSortedDraggableElements() {
            return this.getDraggableElements().stream().filter(e -> Position.getY((Element)e) > -1).sorted(Comparator.comparing(Position::getDoubleY)).collect(Collectors.toList());
        }

        private List<HTMLElement> asList(NodeList<Element> nodeList) {
            ArrayList<HTMLElement> list = new ArrayList<HTMLElement>();
            int i = 0;
            while ((double)i < nodeList.length) {
                list.add((HTMLElement)nodeList.getAt(i));
                ++i;
            }
            return list;
        }
    }

    static class Position {
        Position() {
        }

        static void setX(Element element, double positionX) {
            element.setAttribute(DNDListDOMHelper.DATA_X_POSITION, positionX);
        }

        static Integer getX(Element element) {
            return DNDListDOMHelper.parseInt(element.getAttribute(DNDListDOMHelper.DATA_X_POSITION));
        }

        static void setY(Element element, double positionY) {
            element.setAttribute(DNDListDOMHelper.DATA_Y_POSITION, positionY);
        }

        static Integer getY(Element element) {
            return DNDListDOMHelper.parseInt(element.getAttribute(DNDListDOMHelper.DATA_Y_POSITION));
        }

        static Double getDoubleY(Element element) {
            return DNDListDOMHelper.parseDouble(element.getAttribute(DNDListDOMHelper.DATA_Y_POSITION));
        }
    }
}

