/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.persistence;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.persistence.CreationType;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeRecordEngine;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionStore;
import org.kie.workbench.common.dmn.client.editors.types.persistence.handlers.DataTypeCreateHandler;
import org.kie.workbench.common.dmn.client.editors.types.persistence.handlers.DataTypeDestroyHandler;
import org.kie.workbench.common.dmn.client.editors.types.persistence.handlers.DataTypeUpdateHandler;
import org.kie.workbench.common.dmn.client.editors.types.persistence.handlers.ItemDefinitionCreateHandler;
import org.kie.workbench.common.dmn.client.editors.types.persistence.handlers.ItemDefinitionDestroyHandler;
import org.kie.workbench.common.dmn.client.editors.types.persistence.handlers.ItemDefinitionUpdateHandler;
import org.kie.workbench.common.dmn.client.editors.types.persistence.validation.DataTypeNameValidator;

@ApplicationScoped
public class ItemDefinitionRecordEngine
implements DataTypeRecordEngine {
    private final ItemDefinitionStore itemDefinitionStore;
    private final ItemDefinitionDestroyHandler itemDefinitionDestroyHandler;
    private final ItemDefinitionUpdateHandler itemDefinitionUpdateHandler;
    private final ItemDefinitionCreateHandler itemDefinitionCreateHandler;
    private final DataTypeDestroyHandler dataTypeDestroyHandler;
    private final DataTypeUpdateHandler dataTypeUpdateHandler;
    private final DataTypeCreateHandler dataTypeCreateHandler;
    private final DataTypeNameValidator dataTypeNameValidator;

    @Inject
    public ItemDefinitionRecordEngine(ItemDefinitionStore itemDefinitionStore, ItemDefinitionDestroyHandler itemDefinitionDestroyHandler, ItemDefinitionUpdateHandler itemDefinitionUpdateHandler, ItemDefinitionCreateHandler itemDefinitionCreateHandler, DataTypeDestroyHandler dataTypeDestroyHandler, DataTypeUpdateHandler dataTypeUpdateHandler, DataTypeCreateHandler dataTypeCreateHandler, DataTypeNameValidator dataTypeNameValidator) {
        this.itemDefinitionStore = itemDefinitionStore;
        this.itemDefinitionDestroyHandler = itemDefinitionDestroyHandler;
        this.itemDefinitionUpdateHandler = itemDefinitionUpdateHandler;
        this.itemDefinitionCreateHandler = itemDefinitionCreateHandler;
        this.dataTypeDestroyHandler = dataTypeDestroyHandler;
        this.dataTypeUpdateHandler = dataTypeUpdateHandler;
        this.dataTypeCreateHandler = dataTypeCreateHandler;
        this.dataTypeNameValidator = dataTypeNameValidator;
    }

    @PostConstruct
    public void init() {
        this.dataTypeCreateHandler.init(this);
        this.dataTypeDestroyHandler.init(this);
        this.dataTypeUpdateHandler.init(this);
    }

    @Override
    public List<DataType> update(DataType dataType) {
        if (!dataType.isValid()) {
            throw new UnsupportedOperationException("An invalid Data Type cannot be updated.");
        }
        ItemDefinition itemDefinition = this.itemDefinitionStore.get(dataType.getUUID());
        String itemDefinitionBeforeUpdate = itemDefinition.getName().getValue();
        this.doUpdate(dataType, itemDefinition);
        return this.refreshDependentDataTypesFromUpdateOperation(dataType, itemDefinitionBeforeUpdate);
    }

    @Override
    public List<DataType> destroy(DataType dataType) {
        this.doDestroy(dataType);
        return this.refreshDependentDataTypesFromDestroyOperation(dataType);
    }

    @Override
    public List<DataType> destroyWithoutDependentTypes(DataType dataType) {
        ArrayList<DataType> affectedDataTypes = new ArrayList<DataType>();
        affectedDataTypes.add(dataType);
        this.doDestroy(dataType);
        return affectedDataTypes;
    }

    @Override
    public List<DataType> create(DataType dataType) {
        return this.dataTypeCreateHandler.append(dataType, this.itemDefinitionCreateHandler.appendItemDefinition());
    }

    @Override
    public List<DataType> create(DataType record, DataType reference, CreationType creationType) {
        if (creationType == CreationType.NESTED) {
            return this.insertNested(record, reference);
        }
        return this.insertSibling(record, reference, creationType);
    }

    @Override
    public boolean isValid(DataType dataType) {
        return this.dataTypeNameValidator.isValid(dataType);
    }

    public void doUpdate(DataType dataType, ItemDefinition itemDefinition) {
        this.dataTypeUpdateHandler.update(dataType);
        this.itemDefinitionUpdateHandler.update(dataType, itemDefinition);
    }

    public void doDestroy(DataType dataType) {
        this.dataTypeDestroyHandler.destroy(dataType);
        this.itemDefinitionDestroyHandler.destroy(dataType);
    }

    private List<DataType> refreshDependentDataTypesFromUpdateOperation(DataType dataType, String itemDefinitionName) {
        return this.dataTypeUpdateHandler.refreshDependentDataTypes(dataType, itemDefinitionName);
    }

    private List<DataType> refreshDependentDataTypesFromDestroyOperation(DataType dataType) {
        return this.dataTypeDestroyHandler.refreshDependentDataTypes(dataType);
    }

    private List<DataType> insertNested(DataType record, DataType reference) {
        ItemDefinition nestedItemDefinition = this.itemDefinitionCreateHandler.insertNested(record, reference);
        return this.dataTypeCreateHandler.insertNested(record, reference, nestedItemDefinition);
    }

    private List<DataType> insertSibling(DataType record, DataType reference, CreationType creationType) {
        ItemDefinition siblingItemDefinition = this.itemDefinitionCreateHandler.insertSibling(record, reference, creationType);
        return this.dataTypeCreateHandler.insertSibling(record, reference, creationType, siblingItemDefinition);
    }
}

