/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.persistence.validation;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.editors.types.BuiltInTypeUtils;
import org.kie.workbench.common.dmn.client.editors.common.messages.FlashMessage;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.errors.DataTypeNameIsBlankErrorMessage;
import org.kie.workbench.common.dmn.client.editors.types.common.errors.DataTypeNameIsDefaultTypeMessage;
import org.kie.workbench.common.dmn.client.editors.types.common.errors.DataTypeNameIsNotUniqueErrorMessage;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;
import org.kie.workbench.common.stunner.core.util.StringUtils;

public class DataTypeNameValidator {
    private final Event<FlashMessage> flashMessageEvent;
    private final DataTypeNameIsBlankErrorMessage blankErrorMessage;
    private final DataTypeNameIsNotUniqueErrorMessage notUniqueErrorMessage;
    private final DataTypeNameIsDefaultTypeMessage nameIsDefaultTypeMessage;
    private final DataTypeStore dataTypeStore;

    @Inject
    public DataTypeNameValidator(Event<FlashMessage> flashMessageEvent, DataTypeNameIsBlankErrorMessage blankErrorMessage, DataTypeNameIsNotUniqueErrorMessage notUniqueErrorMessage, DataTypeNameIsDefaultTypeMessage nameIsDefaultTypeMessage, DataTypeStore dataTypeStore) {
        this.flashMessageEvent = flashMessageEvent;
        this.blankErrorMessage = blankErrorMessage;
        this.notUniqueErrorMessage = notUniqueErrorMessage;
        this.nameIsDefaultTypeMessage = nameIsDefaultTypeMessage;
        this.dataTypeStore = dataTypeStore;
    }

    public boolean isValid(DataType dataType) {
        if (this.isBlank(dataType)) {
            this.flashMessageEvent.fire((Object)this.blankErrorMessage.getFlashMessage(dataType));
            return false;
        }
        if (this.isNotUnique(dataType)) {
            this.flashMessageEvent.fire((Object)this.notUniqueErrorMessage.getFlashMessage(dataType));
            return false;
        }
        if (this.isDefault(dataType)) {
            this.flashMessageEvent.fire((Object)this.nameIsDefaultTypeMessage.getFlashMessage(dataType));
            return false;
        }
        return true;
    }

    boolean isDefault(DataType dataType) {
        return BuiltInTypeUtils.isBuiltInType((String)dataType.getName());
    }

    public boolean isNotUnique(DataType dataType) {
        List<DataType> siblings = this.siblings(dataType);
        return siblings.stream().anyMatch(sibling -> {
            boolean isNameEquals = Objects.equals(sibling.getName(), dataType.getName());
            boolean isOtherDataType = !Objects.equals(sibling.getUUID(), dataType.getUUID());
            return isNameEquals && isOtherDataType;
        });
    }

    boolean isBlank(DataType dataType) {
        return StringUtils.isEmpty((String)dataType.getName());
    }

    public List<DataType> siblings(DataType dataType) {
        Optional<DataType> parent = Optional.ofNullable(this.dataTypeStore.get(dataType.getParentUUID()));
        if (parent.isPresent()) {
            return parent.get().getSubDataTypes();
        }
        return this.dataTypeStore.getTopLevelDataTypes();
    }
}

