/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.columns;

import java.util.Optional;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditableHeaderMetaData;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.HasCellEditorControls;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellEditContext;

public abstract class EditablePopupHeaderMetaData<G, E extends HasCellEditorControls.Editor<G>>
implements EditableHeaderMetaData {
    protected CellEditorControlsView.Presenter cellEditorControls;
    protected E editor;
    protected Optional<String> editorTitle;

    public EditablePopupHeaderMetaData(CellEditorControlsView.Presenter cellEditorControls, E editor, Optional<String> editorTitle) {
        this.cellEditorControls = cellEditorControls;
        this.editor = editor;
        this.editorTitle = editorTitle;
    }

    protected abstract G getPresenter();

    public void setColumnGroup(String columnGroup) {
        throw new UnsupportedOperationException("Group cannot be set.");
    }

    public void setTitle(String title) {
        throw new UnsupportedOperationException("Title is derived and cannot be set on the HeaderMetaData.");
    }

    public void edit(GridBodyCellEditContext context) {
        int uiRowIndex = context.getRowIndex();
        int uiColumnIndex = context.getColumnIndex();
        double cellWidth = context.getCellWidth();
        double cellHeight = context.getCellHeight();
        double absoluteCellX = context.getAbsoluteCellX();
        double absoluteCellY = context.getAbsoluteCellY();
        this.editor.bind(this.getPresenter(), uiRowIndex, uiColumnIndex);
        double[] dxy = new double[]{absoluteCellX + cellWidth / 2.0, absoluteCellY + cellHeight / 2.0};
        Optional rx = context.getRelativeLocation();
        rx.ifPresent(r -> {
            dxy[0] = r.getX();
            dxy[1] = r.getY();
        });
        this.cellEditorControls.show((HasCellEditorControls.Editor<?>)this.editor, this.editorTitle, (int)dxy[0], (int)dxy[1]);
    }

    public void destroyResources() {
        this.editor.hide();
    }
}

