/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.canvas.controls.resize;

import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.model.DecisionService;
import org.kie.workbench.common.dmn.api.qualifiers.DMNEditor;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.dmn.client.shape.view.decisionservice.DecisionServiceSVGShapeView;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerRegistrationControl;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.RequiresCommandManager;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.shape.view.event.DragEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.DragHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionAdapter;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class DecisionServiceMoveDividerControl
extends AbstractCanvasHandlerRegistrationControl<AbstractCanvasHandler>
implements RequiresCommandManager<AbstractCanvasHandler>,
RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> {
    static final String DIVIDER_Y_PROPERTY_ID = "dividerLineY";
    private static Logger LOGGER = Logger.getLogger(DecisionServiceMoveDividerControl.class.getName());
    private final DefaultCanvasCommandFactory canvasCommandFactory;
    private RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> commandManagerProvider;

    protected DecisionServiceMoveDividerControl() {
        this(null);
    }

    @Inject
    public DecisionServiceMoveDividerControl(@DMNEditor DefaultCanvasCommandFactory canvasCommandFactory) {
        this.canvasCommandFactory = canvasCommandFactory;
    }

    public void register(final Element element) {
        if (this.checkNotRegistered(element)) {
            Object definition = ((Definition)element.getContent()).getDefinition();
            if (!this.isDecisionServiceDefinition(definition)) {
                return;
            }
            Canvas canvas = this.canvasHandler.getCanvas();
            Shape shape = canvas.getShape(element.getUUID());
            ShapeView shapeView = shape.getShapeView();
            if (!this.isDecisionServiceShapeView(shapeView)) {
                return;
            }
            final DecisionServiceSVGShapeView decisionServiceShapeView = (DecisionServiceSVGShapeView)shapeView;
            DragHandler dragHandler = new DragHandler(){

                public void end(DragEvent event) {
                    CommandResult result = DecisionServiceMoveDividerControl.this.doMoveDivider(element, decisionServiceShapeView.getDividerLineY());
                    if (CommandUtils.isError((CommandResult)result)) {
                        LOGGER.log(Level.WARNING, "Command failed at resize end [result=" + result + "]");
                    }
                }
            };
            decisionServiceShapeView.addDividerDragHandler(dragHandler);
            this.registerHandler(element.getUUID(), (ViewHandler<?>)dragHandler);
        }
    }

    private boolean isDecisionServiceDefinition(Object definition) {
        return definition instanceof DecisionService;
    }

    private boolean isDecisionServiceShapeView(ShapeView<?> view) {
        return view instanceof DecisionServiceSVGShapeView;
    }

    private CommandResult<CanvasViolation> doMoveDivider(Element<? extends View<?>> element, double dividerY) {
        Optional<CanvasCommand<AbstractCanvasHandler>> oCommand = this.getMoveDividerCommand(element, dividerY);
        if (oCommand.isPresent()) {
            CanvasCommand<AbstractCanvasHandler> command = oCommand.get();
            return this.getCommandManager().execute((Object)this.canvasHandler, command);
        }
        return CanvasCommandResultBuilder.failed();
    }

    private Optional<CanvasCommand<AbstractCanvasHandler>> getMoveDividerCommand(Element<? extends Definition<?>> element, double dividerY) {
        Definition content = (Definition)element.getContent();
        Object definition = content.getDefinition();
        DefinitionAdapter adapter = this.canvasHandler.getDefinitionManager().adapters().registry().getDefinitionAdapter(definition.getClass());
        Optional dividerYProperty = adapter.getProperty(definition, DIVIDER_Y_PROPERTY_ID);
        if (dividerYProperty.isPresent()) {
            Object dyp = dividerYProperty.get();
            String id = this.canvasHandler.getDefinitionManager().adapters().forProperty().getId(dyp);
            return Optional.of(this.canvasCommandFactory.updatePropertyValue(element, id, dividerY));
        }
        return Optional.empty();
    }

    public void registerHandler(String uuid, ViewHandler<?> handler) {
        super.registerHandler(uuid, handler);
    }

    protected void doDestroy() {
        super.doDestroy();
        this.commandManagerProvider = null;
    }

    public void setCommandManagerProvider(RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> provider) {
        this.commandManagerProvider = provider;
    }

    public CanvasCommandManager<AbstractCanvasHandler> getCommandManager() {
        return this.commandManagerProvider.getCommandManager();
    }
}

