/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.dtable;

import java.util.Optional;
import java.util.function.Supplier;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.model.RuleAnnotationClause;
import org.kie.workbench.common.dmn.api.definition.model.RuleAnnotationClauseText;
import org.kie.workbench.common.dmn.client.commands.VetoExecutionCommand;
import org.kie.workbench.common.dmn.client.commands.VetoUndoCommand;
import org.kie.workbench.common.dmn.client.commands.util.CommandUtils;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableDefaultValueUtilities;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableUIModelMapper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.RuleAnnotationClauseColumn;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.mvp.Command;

public class AddRuleAnnotationClauseCommand
extends AbstractCanvasGraphCommand
implements VetoExecutionCommand,
VetoUndoCommand {
    private final DecisionTable decisionTable;
    private final RuleAnnotationClause ruleAnnotationClause;
    private final GridData uiModel;
    private final Supplier<RuleAnnotationClauseColumn> uiModelColumnSupplier;
    private final int uiColumnIndex;
    private final DecisionTableUIModelMapper uiModelMapper;
    private final Command executeCanvasOperation;
    private final Command undoCanvasOperation;
    private String name;
    private Optional<RuleAnnotationClauseColumn> uiModelColumn = Optional.empty();

    public AddRuleAnnotationClauseCommand(DecisionTable decisionTable, RuleAnnotationClause ruleAnnotationClause, GridData uiModel, Supplier<RuleAnnotationClauseColumn> uiModelColumnSupplier, int uiColumnIndex, DecisionTableUIModelMapper uiModelMapper, Command executeCanvasOperation, Command undoCanvasOperation) {
        this.decisionTable = decisionTable;
        this.ruleAnnotationClause = ruleAnnotationClause;
        this.uiModel = uiModel;
        this.uiModelColumnSupplier = uiModelColumnSupplier;
        this.uiColumnIndex = uiColumnIndex;
        this.uiModelMapper = uiModelMapper;
        this.executeCanvasOperation = executeCanvasOperation;
        this.undoCanvasOperation = undoCanvasOperation;
        this.name = this.getNewRuleAnnotationClauseName();
    }

    Optional<RuleAnnotationClauseColumn> getUiModelColumn() {
        return this.uiModelColumn;
    }

    private String getName() {
        return this.name;
    }

    String getNewRuleAnnotationClauseName() {
        return DecisionTableDefaultValueUtilities.getNewRuleAnnotationClauseName(this.decisionTable);
    }

    protected org.kie.workbench.common.stunner.core.command.Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler context) {
        return new AbstractGraphCommand(){

            protected CommandResult<RuleViolation> check(GraphCommandExecutionContext context) {
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
                AddRuleAnnotationClauseCommand.this.decisionTable.getComponentWidths().add(AddRuleAnnotationClauseCommand.this.uiColumnIndex, null);
                int clauseIndex = AddRuleAnnotationClauseCommand.this.getClauseIndex();
                AddRuleAnnotationClauseCommand.this.decisionTable.getAnnotations().add(clauseIndex, AddRuleAnnotationClauseCommand.this.ruleAnnotationClause);
                AddRuleAnnotationClauseCommand.this.ruleAnnotationClause.getName().setValue(AddRuleAnnotationClauseCommand.this.getName());
                AddRuleAnnotationClauseCommand.this.decisionTable.getRule().forEach(rule -> {
                    RuleAnnotationClauseText ruleAnnotationClauseText = new RuleAnnotationClauseText();
                    ruleAnnotationClauseText.getText().setValue("");
                    rule.getAnnotationEntry().add(clauseIndex, ruleAnnotationClauseText);
                    ruleAnnotationClauseText.setParent((DMNModelInstrumentedBase)rule);
                });
                AddRuleAnnotationClauseCommand.this.ruleAnnotationClause.setParent((DMNModelInstrumentedBase)AddRuleAnnotationClauseCommand.this.decisionTable);
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
                AddRuleAnnotationClauseCommand.this.decisionTable.getComponentWidths().remove(AddRuleAnnotationClauseCommand.this.uiColumnIndex);
                int clauseIndex = AddRuleAnnotationClauseCommand.this.decisionTable.getAnnotations().indexOf(AddRuleAnnotationClauseCommand.this.ruleAnnotationClause);
                AddRuleAnnotationClauseCommand.this.decisionTable.getRule().forEach(rule -> {
                    RuleAnnotationClauseText cfr_ignored_0 = (RuleAnnotationClauseText)rule.getAnnotationEntry().remove(clauseIndex);
                });
                AddRuleAnnotationClauseCommand.this.decisionTable.getAnnotations().remove(AddRuleAnnotationClauseCommand.this.ruleAnnotationClause);
                return GraphCommandResultBuilder.SUCCESS;
            }
        };
    }

    int getClauseIndex() {
        return this.uiColumnIndex - 1 - this.decisionTable.getInput().size() - this.decisionTable.getOutput().size();
    }

    protected org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler context) {
        return new AbstractCanvasCommand(){

            public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
                if (!AddRuleAnnotationClauseCommand.this.getUiModelColumn().isPresent()) {
                    AddRuleAnnotationClauseCommand.this.uiModelColumn = Optional.of(AddRuleAnnotationClauseCommand.this.uiModelColumnSupplier.get());
                }
                AddRuleAnnotationClauseCommand.this.getUiModelColumn().ifPresent(c -> AddRuleAnnotationClauseCommand.this.uiModel.insertColumn(AddRuleAnnotationClauseCommand.this.uiColumnIndex, (GridColumn)c));
                for (int rowIndex = 0; rowIndex < AddRuleAnnotationClauseCommand.this.decisionTable.getRule().size(); ++rowIndex) {
                    AddRuleAnnotationClauseCommand.this.uiModelMapper.fromDMNModel(rowIndex, AddRuleAnnotationClauseCommand.this.uiColumnIndex);
                }
                AddRuleAnnotationClauseCommand.this.updateParentInformation();
                AddRuleAnnotationClauseCommand.this.executeCanvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }

            public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
                AddRuleAnnotationClauseCommand.this.getUiModelColumn().ifPresent(arg_0 -> ((GridData)AddRuleAnnotationClauseCommand.this.uiModel).deleteColumn(arg_0));
                AddRuleAnnotationClauseCommand.this.updateParentInformation();
                AddRuleAnnotationClauseCommand.this.undoCanvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }
        };
    }

    public void updateParentInformation() {
        CommandUtils.updateParentInformation(this.uiModel);
    }
}

