/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.list;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.client.commands.VetoExecutionCommand;
import org.kie.workbench.common.dmn.client.commands.VetoUndoCommand;
import org.kie.workbench.common.dmn.client.commands.util.CommandUtils;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.mvp.Command;

public class MoveRowsCommand
extends AbstractCanvasGraphCommand
implements VetoExecutionCommand,
VetoUndoCommand {
    private final org.kie.workbench.common.dmn.api.definition.model.List list;
    private final DMNGridData uiModel;
    private final int index;
    private final List<GridRow> rows;
    private final Command canvasOperation;
    private final int oldIndex;

    public MoveRowsCommand(org.kie.workbench.common.dmn.api.definition.model.List list, DMNGridData uiModel, int index, List<GridRow> rows, Command canvasOperation) {
        this.list = list;
        this.uiModel = uiModel;
        this.index = index;
        this.rows = new ArrayList<GridRow>(rows);
        this.canvasOperation = canvasOperation;
        this.oldIndex = uiModel.getRows().indexOf(rows.get(0));
    }

    protected org.kie.workbench.common.stunner.core.command.Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler context) {
        return new AbstractGraphCommand(){

            protected CommandResult<RuleViolation> check(GraphCommandExecutionContext context) {
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
                this.moveRows(MoveRowsCommand.this.index);
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
                this.moveRows(MoveRowsCommand.this.oldIndex);
                return GraphCommandResultBuilder.SUCCESS;
            }

            private void moveRows(int index) {
                List rowsToMove = MoveRowsCommand.this.rows.stream().map(r -> MoveRowsCommand.this.uiModel.getRows().indexOf(r)).map(i -> (HasExpression)MoveRowsCommand.this.list.getExpression().get((int)i)).collect(Collectors.toList());
                CommandUtils.moveRows(MoveRowsCommand.this.list.getExpression(), rowsToMove, index);
            }
        };
    }

    protected org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler context) {
        return new AbstractCanvasCommand(){

            public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
                MoveRowsCommand.this.uiModel.moveRowsTo(MoveRowsCommand.this.index, MoveRowsCommand.this.rows);
                MoveRowsCommand.this.updateRowNumbers();
                MoveRowsCommand.this.updateParentInformation();
                MoveRowsCommand.this.canvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }

            public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
                MoveRowsCommand.this.uiModel.moveRowsTo(MoveRowsCommand.this.oldIndex, MoveRowsCommand.this.rows);
                MoveRowsCommand.this.updateRowNumbers();
                MoveRowsCommand.this.updateParentInformation();
                MoveRowsCommand.this.canvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }
        };
    }

    public void updateRowNumbers() {
        CommandUtils.updateRowNumbers((GridData)this.uiModel, IntStream.range(0, this.uiModel.getRowCount()));
    }

    public void updateParentInformation() {
        CommandUtils.updateParentInformation((GridData)this.uiModel);
    }
}

