/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.relation;

import java.util.Optional;
import java.util.function.Supplier;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.Relation;
import org.kie.workbench.common.dmn.client.commands.VetoExecutionCommand;
import org.kie.workbench.common.dmn.client.commands.VetoUndoCommand;
import org.kie.workbench.common.dmn.client.commands.util.CommandUtils;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationDefaultValueUtilities;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationUIModelMapper;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.mvp.Command;

public class AddRelationColumnCommand
extends AbstractCanvasGraphCommand
implements VetoExecutionCommand,
VetoUndoCommand {
    private final Relation relation;
    private final InformationItem informationItem;
    private final GridData uiModel;
    private final Supplier<RelationColumn> uiModelColumnSupplier;
    private final int uiColumnIndex;
    private final RelationUIModelMapper uiModelMapper;
    private final Command executeCanvasOperation;
    private final Command undoCanvasOperation;
    private final String name;
    private Optional<RelationColumn> uiModelColumn = Optional.empty();

    public AddRelationColumnCommand(Relation relation, InformationItem informationItem, GridData uiModel, Supplier<RelationColumn> uiModelColumnSupplier, int uiColumnIndex, RelationUIModelMapper uiModelMapper, Command executeCanvasOperation, Command undoCanvasOperation) {
        this.relation = relation;
        this.informationItem = informationItem;
        this.uiModel = uiModel;
        this.uiModelColumnSupplier = uiModelColumnSupplier;
        this.uiColumnIndex = uiColumnIndex;
        this.uiModelMapper = uiModelMapper;
        this.executeCanvasOperation = executeCanvasOperation;
        this.undoCanvasOperation = undoCanvasOperation;
        this.name = RelationDefaultValueUtilities.getNewColumnName(relation);
    }

    protected org.kie.workbench.common.stunner.core.command.Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler handler) {
        return new AbstractGraphCommand(){

            protected CommandResult<RuleViolation> check(GraphCommandExecutionContext gce) {
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> execute(GraphCommandExecutionContext gce) {
                AddRelationColumnCommand.this.relation.getComponentWidths().add(AddRelationColumnCommand.this.uiColumnIndex, null);
                int iiIndex = AddRelationColumnCommand.this.uiColumnIndex - 1;
                AddRelationColumnCommand.this.relation.getColumn().add(iiIndex, AddRelationColumnCommand.this.informationItem);
                AddRelationColumnCommand.this.informationItem.getName().setValue(AddRelationColumnCommand.this.name);
                AddRelationColumnCommand.this.relation.getRow().forEach(row -> {
                    LiteralExpression le = new LiteralExpression();
                    HasExpression hasExpression = HasExpression.wrap((DMNModelInstrumentedBase)row, (Expression)le);
                    row.getExpression().add(iiIndex, hasExpression);
                    le.setParent((DMNModelInstrumentedBase)row);
                });
                AddRelationColumnCommand.this.informationItem.setParent((DMNModelInstrumentedBase)AddRelationColumnCommand.this.relation);
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> undo(GraphCommandExecutionContext gce) {
                AddRelationColumnCommand.this.relation.getComponentWidths().remove(AddRelationColumnCommand.this.uiColumnIndex);
                int columnIndex = AddRelationColumnCommand.this.relation.getColumn().indexOf(AddRelationColumnCommand.this.informationItem);
                AddRelationColumnCommand.this.relation.getRow().forEach(row -> {
                    HasExpression cfr_ignored_0 = (HasExpression)row.getExpression().remove(columnIndex);
                });
                AddRelationColumnCommand.this.relation.getColumn().remove(AddRelationColumnCommand.this.informationItem);
                return GraphCommandResultBuilder.SUCCESS;
            }
        };
    }

    protected org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler handler) {
        return new AbstractCanvasCommand(){

            public CommandResult<CanvasViolation> execute(AbstractCanvasHandler handler) {
                if (!AddRelationColumnCommand.this.uiModelColumn.isPresent()) {
                    AddRelationColumnCommand.this.uiModelColumn = Optional.of(AddRelationColumnCommand.this.uiModelColumnSupplier.get());
                }
                AddRelationColumnCommand.this.uiModel.insertColumn(AddRelationColumnCommand.this.uiColumnIndex, (GridColumn)AddRelationColumnCommand.this.uiModelColumn.get());
                for (int rowIndex = 0; rowIndex < AddRelationColumnCommand.this.relation.getRow().size(); ++rowIndex) {
                    AddRelationColumnCommand.this.uiModelMapper.fromDMNModel(rowIndex, AddRelationColumnCommand.this.uiColumnIndex);
                }
                AddRelationColumnCommand.this.updateParentInformation();
                AddRelationColumnCommand.this.executeCanvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }

            public CommandResult<CanvasViolation> undo(AbstractCanvasHandler handler) {
                AddRelationColumnCommand.this.uiModelColumn.ifPresent(arg_0 -> ((GridData)AddRelationColumnCommand.this.uiModel).deleteColumn(arg_0));
                AddRelationColumnCommand.this.updateParentInformation();
                AddRelationColumnCommand.this.undoCanvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }
        };
    }

    public void updateParentInformation() {
        CommandUtils.updateParentInformation(this.uiModel);
    }
}

