/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.general;

import java.util.Optional;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.client.commands.VetoExecutionCommand;
import org.kie.workbench.common.dmn.client.commands.VetoUndoCommand;
import org.kie.workbench.common.dmn.client.commands.util.CommandUtils;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.grid.model.UIModelMapper;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.mvp.Command;

public abstract class BaseClearExpressionCommand
extends AbstractCanvasGraphCommand
implements VetoExecutionCommand,
VetoUndoCommand {
    protected final GridCellTuple cellTuple;
    protected final HasExpression hasExpression;
    protected final UIModelMapper uiModelMapper;
    protected final Command executeCanvasOperation;
    protected final Command undoCanvasOperation;
    protected final Expression oldExpression;
    protected final Optional<GridCellValue<?>> oldCellValue;

    public BaseClearExpressionCommand(GridCellTuple cellTuple, HasExpression hasExpression, UIModelMapper uiModelMapper, Command executeCanvasOperation, Command undoCanvasOperation) {
        this.cellTuple = cellTuple;
        this.hasExpression = hasExpression;
        this.uiModelMapper = uiModelMapper;
        this.executeCanvasOperation = executeCanvasOperation;
        this.undoCanvasOperation = undoCanvasOperation;
        this.oldExpression = hasExpression.getExpression();
        this.oldCellValue = CommandUtils.extractGridCellValue(cellTuple);
    }

    protected org.kie.workbench.common.stunner.core.command.Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler context) {
        return new AbstractGraphCommand(){

            protected CommandResult<RuleViolation> check(GraphCommandExecutionContext context) {
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
                BaseClearExpressionCommand.this.hasExpression.setExpression(null);
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
                BaseClearExpressionCommand.this.hasExpression.setExpression(BaseClearExpressionCommand.this.oldExpression);
                return GraphCommandResultBuilder.SUCCESS;
            }
        };
    }

    protected org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler context) {
        return new AbstractCanvasCommand(){

            public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
                BaseClearExpressionCommand.this.uiModelMapper.fromDMNModel(BaseClearExpressionCommand.this.cellTuple.getRowIndex(), BaseClearExpressionCommand.this.cellTuple.getColumnIndex());
                BaseClearExpressionCommand.this.executeCanvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }

            public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
                BaseClearExpressionCommand.this.oldCellValue.ifPresent(v -> BaseClearExpressionCommand.this.cellTuple.getGridWidget().getModel().setCellValue(BaseClearExpressionCommand.this.cellTuple.getRowIndex(), BaseClearExpressionCommand.this.cellTuple.getColumnIndex(), v));
                BaseClearExpressionCommand.this.undoCanvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }
        };
    }
}

