/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItem;
import org.kie.workbench.common.dmn.client.docks.navigator.factories.DecisionNavigatorItemFactory;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.AbstractChildrenTraverseCallback;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.ChildrenTraverseProcessor;

@Dependent
public class DecisionNavigatorChildrenTraverse {
    private final ChildrenTraverseProcessor traverseProcessor;
    private final DecisionNavigatorItemFactory itemFactory;

    @Inject
    public DecisionNavigatorChildrenTraverse(ChildrenTraverseProcessor traverseProcessor, DecisionNavigatorItemFactory itemFactory) {
        this.traverseProcessor = traverseProcessor;
        this.itemFactory = itemFactory;
    }

    public List<DecisionNavigatorItem> getItems(Graph graph) {
        TraverseCallback traverseCallback = this.makeTraverseCallback();
        this.traverseProcessor.traverse((Object)graph, (Object)traverseCallback);
        return traverseCallback.getItems();
    }

    TraverseCallback makeTraverseCallback() {
        return new TraverseCallback();
    }

    class TraverseCallback
    extends AbstractChildrenTraverseCallback<Node<View, Edge>, Edge<Child, Node>> {
        private List<DecisionNavigatorItem> items = new ArrayList<DecisionNavigatorItem>();

        TraverseCallback() {
        }

        List<DecisionNavigatorItem> getItems() {
            return this.items;
        }

        public boolean startNodeTraversal(List<Node<View, Edge>> parents, Node<View, Edge> node) {
            super.startNodeTraversal(parents, node);
            Node<View, Edge> parentNode = parents.get(0);
            DecisionNavigatorItem item = DecisionNavigatorChildrenTraverse.this.itemFactory.makeItem(node);
            this.findItem(parentNode).ifPresent(parent -> parent.addChild(item));
            return true;
        }

        public void startNodeTraversal(Node<View, Edge> node) {
            super.startNodeTraversal(node);
            this.getItems().add(DecisionNavigatorChildrenTraverse.this.itemFactory.makeRoot(node));
        }

        Optional<DecisionNavigatorItem> findItem(Node<View, Edge> node) {
            return this.getItems().stream().filter(item -> Objects.equals(item.getUUID(), node.getUUID())).findFirst();
        }
    }
}

