/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.appformer.client.context.Channel;
import org.appformer.client.context.EditorContextProvider;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorChildrenTraverse;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItem;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorObserver;
import org.kie.workbench.common.dmn.client.docks.navigator.events.RefreshDecisionComponents;
import org.kie.workbench.common.dmn.client.docks.navigator.factories.DecisionNavigatorItemFactory;
import org.kie.workbench.common.dmn.client.docks.navigator.included.components.DecisionComponents;
import org.kie.workbench.common.dmn.client.docks.navigator.tree.DecisionNavigatorTreePresenter;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.uberfire.client.annotations.DefaultPosition;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.Position;

@ApplicationScoped
@WorkbenchScreen(identifier="org.kie.dmn.decision.navigator")
public class DecisionNavigatorPresenter {
    public static final String IDENTIFIER = "org.kie.dmn.decision.navigator";
    private View view;
    private DecisionNavigatorTreePresenter treePresenter;
    private DecisionComponents decisionComponents;
    private DecisionNavigatorObserver decisionNavigatorObserver;
    private DecisionNavigatorChildrenTraverse navigatorChildrenTraverse;
    private DecisionNavigatorItemFactory itemFactory;
    private TranslationService translationService;
    private CanvasHandler handler;
    private EditorContextProvider context;

    protected DecisionNavigatorPresenter() {
    }

    @Inject
    public DecisionNavigatorPresenter(View view, DecisionNavigatorTreePresenter treePresenter, DecisionComponents decisionComponents, DecisionNavigatorObserver decisionNavigatorObserver, DecisionNavigatorChildrenTraverse navigatorChildrenTraverse, DecisionNavigatorItemFactory itemFactory, TranslationService translationService, EditorContextProvider context) {
        this.view = view;
        this.treePresenter = treePresenter;
        this.decisionComponents = decisionComponents;
        this.decisionNavigatorObserver = decisionNavigatorObserver;
        this.navigatorChildrenTraverse = navigatorChildrenTraverse;
        this.itemFactory = itemFactory;
        this.translationService = translationService;
        this.context = context;
    }

    @WorkbenchPartView
    public View getView() {
        return this.view;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.translationService.format("DecisionNavigatorPresenter.DecisionNavigator", new Object[0]);
    }

    @DefaultPosition
    public Position getDefaultPosition() {
        return CompassPosition.WEST;
    }

    @PostConstruct
    void setup() {
        this.initialize();
        this.setupView();
    }

    public void onRefreshDecisionComponents(@Observes RefreshDecisionComponents events) {
        this.refreshComponentsView();
    }

    public DecisionNavigatorTreePresenter getTreePresenter() {
        return this.treePresenter;
    }

    public Diagram getDiagram() {
        return this.handler.getDiagram();
    }

    public CanvasHandler getHandler() {
        return this.handler;
    }

    public void setHandler(CanvasHandler handler) {
        this.handler = handler;
        this.refreshTreeView();
        this.refreshComponentsView();
    }

    public void addOrUpdateElement(Element<?> element) {
        if (!this.isNode(element)) {
            return;
        }
        this.treePresenter.addOrUpdateItem(this.makeItem(element));
    }

    public void updateElement(Element<?> element) {
        if (!this.isNode(element)) {
            return;
        }
        this.treePresenter.updateItem(this.makeItem(element));
    }

    public void removeElement(Element<?> element) {
        if (!this.isNode(element)) {
            return;
        }
        this.treePresenter.remove(this.makeItem(element));
    }

    public void removeAllElements() {
        this.treePresenter.removeAllItems();
        this.decisionComponents.removeAllItems();
    }

    void initialize() {
        this.view.init(this);
        this.decisionNavigatorObserver.init(this);
    }

    void setupView() {
        this.view.setupMainTree(this.treePresenter.getView());
        Channel channel = this.context.getChannel();
        if (Objects.equals(channel, Channel.VSCODE) || Objects.equals(channel, Channel.DEFAULT)) {
            this.view.showDecisionComponentsContainer();
            this.view.setupDecisionComponents(this.decisionComponents.getView());
        } else {
            this.view.hideDecisionComponentsContainer();
        }
    }

    public void refreshTreeView() {
        this.treePresenter.setupItems(this.getItems());
    }

    public void refreshComponentsView() {
        this.getOptionalHandler().ifPresent(handler -> this.decisionComponents.refresh(handler.getDiagram()));
    }

    List<DecisionNavigatorItem> getItems() {
        return this.getGraph().map(this.navigatorChildrenTraverse::getItems).orElse(Collections.emptyList());
    }

    public Optional<Graph> getGraph() {
        return this.getOptionalHandler().map(CanvasHandler::getDiagram).map(Diagram::getGraph);
    }

    Optional<CanvasHandler> getOptionalHandler() {
        return Optional.ofNullable(this.handler);
    }

    DecisionNavigatorItem makeItem(Element<?> element) {
        Node node = element.asNode();
        return this.itemFactory.makeItem((Node<org.kie.workbench.common.stunner.core.graph.content.view.View, Edge>)node);
    }

    private boolean isNode(Element<?> element) {
        return element instanceof Node;
    }

    public void clearSelections() {
        this.getTreePresenter().deselectItem();
    }

    public static interface View
    extends UberElemental<DecisionNavigatorPresenter>,
    IsElement {
        public void setupMainTree(DecisionNavigatorTreePresenter.View var1);

        public void setupDecisionComponents(DecisionComponents.View var1);

        public void showDecisionComponentsContainer();

        public void hideDecisionComponentsContainer();
    }
}

