/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator.factories;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.StreamSupport;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagram;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItem;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorPresenter;
import org.kie.workbench.common.dmn.client.docks.navigator.factories.DecisionNavigatorNestedItemFactory;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.TextPropertyProvider;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.TextPropertyProviderFactory;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasFocusedShapeEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.definition.adapter.AdapterManager;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionAdapter;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.uberfire.mvp.Command;

@Dependent
public class DecisionNavigatorBaseItemFactory {
    private final DecisionNavigatorNestedItemFactory nestedItemFactory;
    private final DecisionNavigatorPresenter decisionNavigatorPresenter;
    private final TextPropertyProviderFactory textPropertyProviderFactory;
    private final Event<CanvasFocusedShapeEvent> canvasFocusedSelectionEvent;
    private final Event<CanvasSelectionEvent> canvasSelectionEvent;
    private final DefinitionUtils definitionUtils;
    private final TranslationService translationService;

    @Inject
    public DecisionNavigatorBaseItemFactory(DecisionNavigatorNestedItemFactory nestedItemFactory, DecisionNavigatorPresenter decisionNavigatorPresenter, TextPropertyProviderFactory textPropertyProviderFactory, Event<CanvasFocusedShapeEvent> canvasFocusedSelectionEvent, Event<CanvasSelectionEvent> canvasSelectionEvent, DefinitionUtils definitionUtils, TranslationService translationService) {
        this.nestedItemFactory = nestedItemFactory;
        this.decisionNavigatorPresenter = decisionNavigatorPresenter;
        this.textPropertyProviderFactory = textPropertyProviderFactory;
        this.canvasFocusedSelectionEvent = canvasFocusedSelectionEvent;
        this.canvasSelectionEvent = canvasSelectionEvent;
        this.definitionUtils = definitionUtils;
        this.translationService = translationService;
    }

    public DecisionNavigatorItem makeItem(Node<View, Edge> node, DecisionNavigatorItem.Type type) {
        String uuid = node.getUUID();
        String label = this.getLabel((Element<View>)node);
        Command onClick = this.makeOnClickCommand(node);
        List<DecisionNavigatorItem> nestedItems = this.makeNestedItems(node);
        String diagramUUID = this.diagramUUID();
        DecisionNavigatorItem item = new DecisionNavigatorItem(uuid, label, type, onClick, diagramUUID);
        nestedItems.forEach(item::addChild);
        return item;
    }

    String diagramUUID() {
        String defaultUUID = "";
        return this.decisionNavigatorPresenter.getGraph().map(graph -> graph.nodes()).map(nodes -> StreamSupport.stream(nodes.spliterator(), false)).map(stream -> stream.filter(n -> n.getContent() instanceof Definition).filter(n -> ((Definition)n.getContent()).getDefinition() instanceof DMNDiagram).findFirst().map(Element::getUUID).orElse("")).orElse("");
    }

    Command makeOnClickCommand(Node<View, Edge> node) {
        CanvasHandler canvasHandler = this.decisionNavigatorPresenter.getHandler();
        String uuid = node.getUUID();
        return () -> {
            this.canvasSelectionEvent.fire((Object)this.makeCanvasSelectionEvent(canvasHandler, uuid));
            this.canvasFocusedSelectionEvent.fire((Object)this.makeCanvasFocusedShapeEvent(canvasHandler, uuid));
            if (canvasHandler != null && canvasHandler.getCanvas() != null) {
                canvasHandler.getCanvas().focus();
            }
        };
    }

    String getLabel(Element<View> element) {
        String name = this.getName(element);
        String title = this.getTitle(element);
        if (this.isNil(name) && !this.isNil(title)) {
            return title;
        }
        return name != null ? name : this.getDefaultName();
    }

    String getName(Element<? extends Definition> element) {
        TextPropertyProvider provider = this.textPropertyProviderFactory.getProvider(element);
        return provider.getText(element);
    }

    String getTitle(Element<View> element) {
        AdapterManager adapters = this.definitionUtils.getDefinitionManager().adapters();
        DefinitionAdapter objectDefinitionAdapter = adapters.forDefinition();
        return objectDefinitionAdapter.getTitle(DefinitionUtils.getElementDefinition(element));
    }

    List<DecisionNavigatorItem> makeNestedItems(Node<View, Edge> node) {
        ArrayList<DecisionNavigatorItem> nestedItems = new ArrayList<DecisionNavigatorItem>();
        if (this.hasNestedElement(node)) {
            nestedItems.add(this.nestedItemFactory.makeItem(node));
        }
        return nestedItems;
    }

    CanvasSelectionEvent makeCanvasSelectionEvent(CanvasHandler canvas, String uuid) {
        return new CanvasSelectionEvent(canvas, uuid);
    }

    CanvasFocusedShapeEvent makeCanvasFocusedShapeEvent(CanvasHandler canvas, String uuid) {
        return new CanvasFocusedShapeEvent(canvas, uuid);
    }

    private String getDefaultName() {
        return this.translationService.format("DecisionNavigatorBaseItemFactory.NoName", new Object[0]);
    }

    private boolean hasNestedElement(Node<View, Edge> node) {
        return this.nestedItemFactory.hasNestedElement(node);
    }

    private boolean isNil(String s) {
        return s == null || s.trim().isEmpty();
    }
}

