/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.documentation.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.definition.model.UnaryTests;
import org.kie.workbench.common.dmn.client.editors.documentation.common.DMNDocumentation;
import org.kie.workbench.common.dmn.client.editors.documentation.common.DMNDocumentationDRD;
import org.kie.workbench.common.dmn.client.editors.documentation.common.DMNDocumentationDRDsFactory;
import org.kie.workbench.common.dmn.client.editors.documentation.common.DMNDocumentationDataType;
import org.kie.workbench.common.dmn.client.editors.documentation.common.DMNDocumentationI18n;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasFileExport;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.uberfire.client.views.pfly.widgets.Moment;
import org.uberfire.rpc.SessionInfo;

public class DMNDocumentationFactory {
    static final String EMPTY = "";
    private final CanvasFileExport canvasFileExport;
    private final TranslationService translationService;
    private final DMNDocumentationDRDsFactory drdsFactory;
    private final SessionInfo sessionInfo;
    private final DMNGraphUtils graphUtils;

    @Inject
    public DMNDocumentationFactory(CanvasFileExport canvasFileExport, TranslationService translationService, DMNDocumentationDRDsFactory drdsFactory, SessionInfo sessionInfo, DMNGraphUtils graphUtils) {
        this.canvasFileExport = canvasFileExport;
        this.translationService = translationService;
        this.drdsFactory = drdsFactory;
        this.sessionInfo = sessionInfo;
        this.graphUtils = graphUtils;
    }

    public DMNDocumentation create(Diagram diagram) {
        return DMNDocumentation.create(this.getNamespace(diagram), this.getDiagramName(diagram), this.getDiagramDescription(diagram), this.hasGraphNodes(diagram), this.getDataTypes(diagram), this.getDrds(diagram), this.getDiagramImage(), this.getCurrentUserName(), this.getCurrentDate(), this.getDocumentationI18n());
    }

    protected List<DMNDocumentationDRD> getDrds(Diagram diagram) {
        return this.drdsFactory.create(diagram);
    }

    protected String getNamespace(Diagram diagram) {
        return this.graphUtils.getDefinitions(diagram).getNamespace().getValue();
    }

    protected boolean hasGraphNodes(Diagram diagram) {
        return !this.graphUtils.getDRGElements(diagram).isEmpty();
    }

    protected String getDiagramImage() {
        return this.getCanvasHandler().map(arg_0 -> ((CanvasFileExport)this.canvasFileExport).exportToPng(arg_0)).orElse(EMPTY);
    }

    protected List<DMNDocumentationDataType> getDataTypes(Diagram diagram) {
        List itemDefinitions = this.graphUtils.getDefinitions(diagram).getItemDefinition();
        ArrayList<DMNDocumentationDataType> dataTypes = new ArrayList<DMNDocumentationDataType>();
        this.makeDMNDocumentationDataTypes(itemDefinitions, dataTypes, 0);
        return dataTypes;
    }

    private void makeDMNDocumentationDataTypes(List<ItemDefinition> itemDefinitions, List<DMNDocumentationDataType> dataTypes, int level) {
        itemDefinitions.forEach(itemDefinition -> this.makeDMNDocumentationDataType(dataTypes, (ItemDefinition)itemDefinition, level));
    }

    private void makeDMNDocumentationDataType(List<DMNDocumentationDataType> dataTypes, ItemDefinition itemDefinition, int level) {
        String name = itemDefinition.getName().getValue();
        String type = this.getType(itemDefinition);
        String listLabel = this.getListLabel(itemDefinition);
        String constraint = this.getConstraint(itemDefinition);
        DMNDocumentationDataType dataType = DMNDocumentationDataType.create(name, type, listLabel, constraint, level);
        dataTypes.add(dataType);
        this.makeDMNDocumentationDataTypes(itemDefinition.getItemComponent(), dataTypes, level + 1);
    }

    private String getConstraint(ItemDefinition itemDefinition) {
        UnaryTests allowedValues = itemDefinition.getAllowedValues();
        if (allowedValues != null && !StringUtils.isEmpty((String)allowedValues.getText().getValue())) {
            return this.translationService.format("DMNDocumentationFactory.Constraints", new Object[0]) + " " + allowedValues.getText().getValue();
        }
        return EMPTY;
    }

    private String getListLabel(ItemDefinition itemDefinition) {
        if (itemDefinition.isIsCollection()) {
            return this.translationService.format("DMNDocumentationFactory.ListYes", new Object[0]);
        }
        return EMPTY;
    }

    private String getType(ItemDefinition itemDefinition) {
        if (itemDefinition.getTypeRef() != null) {
            return itemDefinition.getTypeRef().getLocalPart();
        }
        return this.translationService.format("DMNDocumentationFactory.Structure", new Object[0]);
    }

    protected String getCurrentDate() {
        return this.moment().format("D MMMM YYYY");
    }

    protected String getDiagramName(Diagram diagram) {
        return this.graphUtils.getDefinitions(diagram).getName().getValue();
    }

    protected String getDiagramDescription(Diagram diagram) {
        return this.graphUtils.getDefinitions(diagram).getDescription().getValue();
    }

    protected String getCurrentUserName() {
        return this.sessionInfo.getIdentity().getIdentifier();
    }

    private Optional<AbstractCanvasHandler> getCanvasHandler() {
        return Optional.ofNullable(this.graphUtils.getCanvasHandler()).filter(c -> c instanceof AbstractCanvasHandler).map(c -> (AbstractCanvasHandler)c);
    }

    protected DMNDocumentationI18n getDocumentationI18n() {
        return DMNDocumentationI18n.create(this.translationService);
    }

    Moment moment() {
        return Moment.Builder.moment();
    }
}

