/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.context;

import java.util.Optional;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.model.Context;
import org.kie.workbench.common.dmn.api.definition.model.ContextEntry;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.qualifiers.DMNEditor;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.dmn.client.editors.expressions.types.BaseEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionType;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextEntryDefaultValueUtilities;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextGridData;
import org.kie.workbench.common.dmn.client.editors.types.ValueAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.uberfire.ext.wires.core.grids.client.model.GridData;

@ApplicationScoped
public class ContextEditorDefinition
extends BaseEditorDefinition<Context, ContextGridData> {
    private Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    private ValueAndDataTypePopoverView.Presenter headerEditor;

    public ContextEditorDefinition() {
    }

    @Inject
    public ContextEditorDefinition(DefinitionUtils definitionUtils, SessionManager sessionManager, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, @DMNEditor DefaultCanvasCommandFactory canvasCommandFactory, Event<ExpressionEditorChanged> editorSelectedEvent, Event<RefreshFormPropertiesEvent> refreshFormPropertiesEvent, Event<DomainObjectSelectionEvent> domainObjectSelectionEvent, ListSelectorView.Presenter listSelector, TranslationService translationService, @DMNEditor Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier, ValueAndDataTypePopoverView.Presenter headerEditor) {
        super(definitionUtils, sessionManager, sessionCommandManager, canvasCommandFactory, editorSelectedEvent, refreshFormPropertiesEvent, domainObjectSelectionEvent, listSelector, translationService);
        this.expressionEditorDefinitionsSupplier = expressionEditorDefinitionsSupplier;
        this.headerEditor = headerEditor;
    }

    @Override
    public ExpressionType getType() {
        return ExpressionType.CONTEXT;
    }

    @Override
    public String getName() {
        return this.translationService.format("ExpressionEditor.ContextExpressionType", new Object[0]);
    }

    @Override
    public Optional<Context> getModelClass() {
        return Optional.of(new Context());
    }

    @Override
    public void enrich(Optional<String> nodeUUID, HasExpression hasExpression, Optional<Context> expression) {
        expression.ifPresent(context -> {
            ContextEntry contextEntry = new ContextEntry();
            InformationItem informationItem = new InformationItem();
            informationItem.getName().setValue(ContextEntryDefaultValueUtilities.getNewContextEntryName(context));
            contextEntry.setVariable(informationItem);
            context.getContextEntry().add(contextEntry);
            ContextEntry resultEntry = new ContextEntry();
            context.getContextEntry().add(resultEntry);
            contextEntry.setParent((DMNModelInstrumentedBase)context);
            informationItem.setParent((DMNModelInstrumentedBase)contextEntry);
            resultEntry.setParent((DMNModelInstrumentedBase)context);
        });
    }

    @Override
    public Optional<BaseExpressionGrid<? extends Expression, ? extends GridData, ? extends BaseUIModelMapper>> getEditor(GridCellTuple parent, Optional<String> nodeUUID, HasExpression hasExpression, Optional<HasName> hasName, boolean isOnlyVisualChangeAllowed, int nesting) {
        return Optional.of(new ContextGrid(parent, nodeUUID, hasExpression, hasName, this.getGridPanel(), this.getGridLayer(), (ContextGridData)this.makeGridData(() -> Optional.ofNullable((Context)hasExpression.getExpression())), this.definitionUtils, this.sessionManager, (SessionCommandManager<AbstractCanvasHandler>)this.sessionCommandManager, this.canvasCommandFactory, (Event<ExpressionEditorChanged>)this.editorSelectedEvent, (Event<RefreshFormPropertiesEvent>)this.refreshFormPropertiesEvent, (Event<DomainObjectSelectionEvent>)this.domainObjectSelectionEvent, this.getCellEditorControls(), this.listSelector, this.translationService, isOnlyVisualChangeAllowed, nesting, this.expressionEditorDefinitionsSupplier, this.headerEditor));
    }

    @Override
    protected ContextGridData makeGridData(Supplier<Optional<Context>> expression) {
        return new ContextGridData(new DMNGridData(), this.sessionManager, (SessionCommandManager<AbstractCanvasHandler>)this.sessionCommandManager, expression, this.getGridLayer()::batch);
    }
}

