/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.dtable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.HasVariable;
import org.kie.workbench.common.dmn.api.definition.model.ContextEntry;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTableOrientation;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.model.HitPolicy;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.definition.model.InputClause;
import org.kie.workbench.common.dmn.api.definition.model.InputClauseLiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.InputData;
import org.kie.workbench.common.dmn.api.definition.model.IsInformationItem;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.OutputClause;
import org.kie.workbench.common.dmn.api.definition.model.RuleAnnotationClause;
import org.kie.workbench.common.dmn.api.definition.model.RuleAnnotationClauseText;
import org.kie.workbench.common.dmn.api.definition.model.UnaryTests;
import org.kie.workbench.common.dmn.api.editors.types.BuiltInTypeUtils;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorModelEnricher;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableDefaultValueUtilities;
import org.kie.workbench.common.dmn.client.editors.expressions.util.TypeRefUtils;
import org.kie.workbench.common.dmn.client.editors.types.common.ItemDefinitionUtils;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;

@ApplicationScoped
public class DecisionTableEditorDefinitionEnricher
implements ExpressionEditorModelEnricher<DecisionTable> {
    private static final String DOT_CHAR = ".";
    private SessionManager sessionManager;
    private DMNGraphUtils dmnGraphUtils;
    private ItemDefinitionUtils itemDefinitionUtils;

    public DecisionTableEditorDefinitionEnricher() {
    }

    @Inject
    public DecisionTableEditorDefinitionEnricher(SessionManager sessionManager, DMNGraphUtils dmnGraphUtils, ItemDefinitionUtils itemDefinitionUtils) {
        this.sessionManager = sessionManager;
        this.dmnGraphUtils = dmnGraphUtils;
        this.itemDefinitionUtils = itemDefinitionUtils;
    }

    @Override
    public void enrich(Optional<String> nodeUUID, HasExpression hasExpression, Optional<DecisionTable> expression) {
        expression.ifPresent(dtable -> {
            dtable.setHitPolicy(HitPolicy.UNIQUE);
            dtable.setPreferredOrientation(DecisionTableOrientation.RULE_AS_ROW);
            InputClause inputClause = new InputClause();
            InputClauseLiteralExpression literalExpression = new InputClauseLiteralExpression();
            literalExpression.getText().setValue(DecisionTableDefaultValueUtilities.getNewInputClauseName(dtable));
            inputClause.setInputExpression(literalExpression);
            dtable.getInput().add(inputClause);
            RuleAnnotationClause ruleAnnotationClause = new RuleAnnotationClause();
            ruleAnnotationClause.getName().setValue(DecisionTableDefaultValueUtilities.getNewRuleAnnotationClauseName(dtable));
            dtable.getAnnotations().add(ruleAnnotationClause);
            DecisionRule decisionRule = new DecisionRule();
            UnaryTests decisionRuleUnaryTest = new UnaryTests();
            decisionRuleUnaryTest.getText().setValue("-");
            decisionRule.getInputEntry().add(decisionRuleUnaryTest);
            this.buildOutputClausesByDataType(hasExpression, (DecisionTable)dtable, decisionRule);
            RuleAnnotationClauseText ruleAnnotationEntry = new RuleAnnotationClauseText();
            ruleAnnotationEntry.getText().setValue("");
            decisionRule.getAnnotationEntry().add(ruleAnnotationEntry);
            dtable.getRule().add(decisionRule);
            inputClause.setParent((DMNModelInstrumentedBase)dtable);
            decisionRule.setParent((DMNModelInstrumentedBase)dtable);
            literalExpression.setParent((DMNModelInstrumentedBase)inputClause);
            decisionRuleUnaryTest.setParent((DMNModelInstrumentedBase)decisionRule);
            ruleAnnotationEntry.setParent((DMNModelInstrumentedBase)dtable);
            if (nodeUUID.isPresent()) {
                this.enrichInputClauses((String)nodeUUID.get(), (DecisionTable)dtable);
            } else {
                this.enrichOutputClauses((DecisionTable)dtable);
            }
        });
    }

    void buildOutputClausesByDataType(HasExpression hasExpression, DecisionTable dTable, DecisionRule decisionRule) {
        HasTypeRef hasTypeRef = this.getHasTypeRef(hasExpression, dTable);
        QName typeRef = !Objects.isNull(hasTypeRef) ? hasTypeRef.getTypeRef() : BuiltInType.UNDEFINED.asQName();
        String name = DecisionTableDefaultValueUtilities.getNewOutputClauseName(dTable);
        List<ClauseRequirement> outputClausesRequirement = this.generateOutputClauseRequirements(this.dmnGraphUtils.getDefinitions(), typeRef, name);
        if (outputClausesRequirement.isEmpty()) {
            dTable.getOutput().add(this.buildOutputClause(dTable, typeRef, name));
            this.populateOutputEntries(decisionRule);
        } else {
            outputClausesRequirement.stream().sorted(Comparator.comparing(outputClauseRequirement -> outputClauseRequirement.text)).map(outputClauseRequirement -> this.buildOutputClause(dTable, outputClauseRequirement.typeRef, outputClauseRequirement.text)).forEach(outputClause -> {
                dTable.getOutput().add(outputClause);
                this.populateOutputEntries(decisionRule);
            });
        }
    }

    private HasTypeRef getHasTypeRef(HasExpression hasExpression, DecisionTable dTable) {
        DMNModelInstrumentedBase parent;
        if (hasExpression instanceof FunctionDefinition && (parent = hasExpression.asDMNModelInstrumentedBase().getParent()) instanceof HasVariable) {
            return ((HasVariable)parent).getVariable();
        }
        return TypeRefUtils.getTypeRefOfExpression(dTable, hasExpression);
    }

    private List<ClauseRequirement> generateOutputClauseRequirements(Definitions definitions, QName typeRef, String name) {
        if (BuiltInTypeUtils.isBuiltInType((String)typeRef.getLocalPart())) {
            return Collections.singletonList(new ClauseRequirement(name, typeRef));
        }
        return definitions.getItemDefinition().stream().filter(this.typeRefIsCustom(typeRef)).findFirst().map(this::generateOutputClauseRequirementsForFirstLevel).orElse(Collections.emptyList());
    }

    private List<ClauseRequirement> generateOutputClauseRequirementsForFirstLevel(ItemDefinition itemDefinition) {
        return itemDefinition.getItemComponent().stream().map(this::definitionToClauseRequirementMapper).collect(Collectors.toList());
    }

    private ClauseRequirement definitionToClauseRequirementMapper(ItemDefinition itemDefinition) {
        QName typeRef = itemDefinition.getTypeRef();
        String name = this.computeClauseName(itemDefinition);
        if (Objects.isNull(typeRef) || this.typeRefDoesNotMatchAnyDefinition(typeRef)) {
            return new ClauseRequirement(name, BuiltInType.ANY.asQName());
        }
        return new ClauseRequirement(name, typeRef);
    }

    private boolean typeRefDoesNotMatchAnyDefinition(QName typeRef) {
        return !BuiltInTypeUtils.isBuiltInType((String)typeRef.getLocalPart()) && this.dmnGraphUtils.getDefinitions().getItemDefinition().stream().noneMatch(this.typeRefIsCustom(typeRef));
    }

    private OutputClause buildOutputClause(DecisionTable dtable, QName typeRef, String text) {
        OutputClause outputClause = new OutputClause();
        outputClause.setName(text);
        outputClause.setTypeRef(typeRef);
        outputClause.setParent((DMNModelInstrumentedBase)dtable);
        return outputClause;
    }

    private void populateOutputEntries(DecisionRule decisionRule) {
        LiteralExpression decisionRuleLiteralExpression = new LiteralExpression();
        decisionRuleLiteralExpression.getText().setValue("");
        decisionRuleLiteralExpression.setParent((DMNModelInstrumentedBase)decisionRule);
        decisionRule.getOutputEntry().add(decisionRuleLiteralExpression);
    }

    void enrichInputClauses(String uuid, DecisionTable dtable) {
        Graph graph = this.sessionManager.getCurrentSession().getCanvasHandler().getDiagram().getGraph();
        Node node = graph.getNode(uuid);
        if (Objects.isNull(node)) {
            return;
        }
        List<Decision> decisionSet = node.getInEdges().stream().map(Edge::getSourceNode).map(Element::getContent).filter(content -> content instanceof Definition).map(content -> (Definition)content).map(Definition::getDefinition).filter(definition -> definition instanceof Decision).map(definition -> (Decision)definition).collect(Collectors.toList());
        List<InputData> inputDataSet = node.getInEdges().stream().map(Edge::getSourceNode).map(Element::getContent).filter(content -> content instanceof Definition).map(content -> (Definition)content).map(Definition::getDefinition).filter(definition -> definition instanceof InputData).map(definition -> (InputData)definition).collect(Collectors.toList());
        if (decisionSet.isEmpty() && inputDataSet.isEmpty()) {
            return;
        }
        Definitions definitions = this.dmnGraphUtils.getDefinitions();
        ArrayList inputClauseRequirements = new ArrayList();
        decisionSet.forEach(decision -> this.addInputClauseRequirement(decision.getVariable().getTypeRef(), definitions, inputClauseRequirements, decision.getName().getValue()));
        inputDataSet.forEach(inputData -> this.addInputClauseRequirement(inputData.getVariable().getTypeRef(), definitions, inputClauseRequirements, inputData.getName().getValue()));
        dtable.getInput().clear();
        dtable.getRule().stream().forEach(decisionRule -> decisionRule.getInputEntry().clear());
        inputClauseRequirements.stream().sorted(Comparator.comparing(inputClauseRequirement -> inputClauseRequirement.text)).forEach(inputClauseRequirement -> {
            InputClause inputClause = new InputClause();
            InputClauseLiteralExpression literalExpression = new InputClauseLiteralExpression();
            literalExpression.getText().setValue(inputClauseRequirement.text);
            literalExpression.setTypeRef(inputClauseRequirement.typeRef);
            inputClause.setInputExpression(literalExpression);
            dtable.getInput().add(inputClause);
            dtable.getRule().stream().forEach(decisionRule -> {
                UnaryTests decisionRuleUnaryTest = new UnaryTests();
                decisionRuleUnaryTest.getText().setValue("-");
                decisionRule.getInputEntry().add(decisionRuleUnaryTest);
                decisionRuleUnaryTest.setParent((DMNModelInstrumentedBase)decisionRule);
            });
            inputClause.setParent((DMNModelInstrumentedBase)dtable);
            literalExpression.setParent((DMNModelInstrumentedBase)inputClause);
        });
    }

    private void addInputClauseRequirement(QName typeRef, Definitions definitions, List<ClauseRequirement> inputClauseRequirements, String text) {
        if (BuiltInTypeUtils.isBuiltInType((String)typeRef.getLocalPart())) {
            inputClauseRequirements.add(new ClauseRequirement(text, typeRef));
            return;
        }
        definitions.getItemDefinition().stream().filter(this.typeRefIsCustom(typeRef)).findFirst().ifPresent(itemDefinition -> this.addInputClauseRequirement((ItemDefinition)itemDefinition, inputClauseRequirements, text));
    }

    void addInputClauseRequirement(ItemDefinition itemDefinition, List<ClauseRequirement> inputClauseRequirements, String text) {
        if (itemDefinition.getItemComponent().size() == 0) {
            inputClauseRequirements.add(new ClauseRequirement(text, this.getQName(itemDefinition)));
        } else {
            itemDefinition.getItemComponent().forEach(itemComponent -> this.addInputClauseRequirement((ItemDefinition)itemComponent, inputClauseRequirements, text + DOT_CHAR + this.computeClauseName((ItemDefinition)itemComponent)));
        }
    }

    String computeClauseName(ItemDefinition itemComponent) {
        int positionOfLastDot;
        String originalName;
        String nameWithoutModelRef = originalName = itemComponent.getName().getValue();
        if (itemComponent.isImported() && (positionOfLastDot = originalName.lastIndexOf(DOT_CHAR) + 1) > 0 && positionOfLastDot != originalName.length()) {
            nameWithoutModelRef = originalName.substring(positionOfLastDot);
        }
        return nameWithoutModelRef;
    }

    private Predicate<ItemDefinition> typeRefIsCustom(QName typeRef) {
        return itemDef -> Objects.equals(itemDef.getName().getValue(), typeRef.getLocalPart());
    }

    private QName getQName(ItemDefinition itemDefinition) {
        return Optional.ofNullable(itemDefinition.getTypeRef()).orElse(this.getQNameFromItemDefinitionName(itemDefinition));
    }

    private QName getQNameFromItemDefinitionName(ItemDefinition itemDefinition) {
        Name name = itemDefinition.getName();
        QName typeRef = new QName("", name.getValue());
        return this.itemDefinitionUtils.normaliseTypeRef(typeRef);
    }

    void enrichOutputClauses(DecisionTable dtable) {
        if (dtable.getParent() instanceof ContextEntry && dtable.getOutput().isEmpty()) {
            ContextEntry contextEntry = (ContextEntry)dtable.getParent();
            OutputClause outputClause = new OutputClause();
            outputClause.setName(this.getOutputClauseName((HasVariable)contextEntry).orElse(DecisionTableDefaultValueUtilities.getNewOutputClauseName(dtable)));
            outputClause.setTypeRef(this.getOutputClauseTypeRef((HasVariable)contextEntry).orElse(BuiltInType.UNDEFINED.asQName()));
            dtable.getOutput().add(outputClause);
            dtable.getRule().stream().forEach(decisionRule -> {
                LiteralExpression decisionRuleLiteralExpression = new LiteralExpression();
                decisionRuleLiteralExpression.getText().setValue("");
                decisionRule.getOutputEntry().add(decisionRuleLiteralExpression);
                decisionRuleLiteralExpression.setParent((DMNModelInstrumentedBase)decisionRule);
            });
            outputClause.setParent((DMNModelInstrumentedBase)dtable);
        }
    }

    private Optional<String> getOutputClauseName(HasVariable hasVariable) {
        IsInformationItem variable = hasVariable.getVariable();
        if (variable instanceof InformationItem) {
            return Optional.ofNullable(variable.getName().getValue());
        }
        DMNModelInstrumentedBase base = hasVariable.asDMNModelInstrumentedBase().getParent();
        DMNModelInstrumentedBase parent = base.getParent();
        if (parent instanceof HasName) {
            return Optional.ofNullable(((HasName)parent).getName().getValue());
        }
        if (parent instanceof HasVariable) {
            return this.getOutputClauseName((HasVariable)parent);
        }
        return Optional.empty();
    }

    private Optional<QName> getOutputClauseTypeRef(HasVariable hasVariable) {
        IsInformationItem variable = hasVariable.getVariable();
        if (Objects.nonNull(variable)) {
            return Optional.ofNullable(variable.getTypeRef());
        }
        DMNModelInstrumentedBase base = hasVariable.asDMNModelInstrumentedBase().getParent();
        DMNModelInstrumentedBase parent = base.getParent();
        if (parent instanceof HasTypeRef) {
            return Optional.ofNullable(((HasTypeRef)parent).getTypeRef());
        }
        if (parent instanceof HasVariable) {
            return this.getOutputClauseTypeRef((HasVariable)parent);
        }
        return Optional.empty();
    }

    static class ClauseRequirement {
        String text;
        QName typeRef;

        ClauseRequirement(String text, QName typeRef) {
            this.text = text;
            this.typeRef = typeRef;
        }
    }
}

