/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function;

import java.util.Optional;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.qualifiers.DMNEditor;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.dmn.client.editors.expressions.types.BaseEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionType;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionGridSupplementaryEditor;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.KindUtilities;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.kindselector.KindPopoverView;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.parameters.ParametersPopoverView;
import org.kie.workbench.common.dmn.client.editors.types.ValueAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.uberfire.ext.wires.core.grids.client.model.GridData;

@ApplicationScoped
public class FunctionEditorDefinition
extends BaseEditorDefinition<FunctionDefinition, DMNGridData> {
    private Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    private Supplier<ExpressionEditorDefinitions> supplementaryEditorDefinitionsSupplier;
    private ValueAndDataTypePopoverView.Presenter headerEditor;
    private ParametersPopoverView.Presenter parametersEditor;
    private KindPopoverView.Presenter kindEditor;

    public FunctionEditorDefinition() {
    }

    @Inject
    public FunctionEditorDefinition(DefinitionUtils definitionUtils, SessionManager sessionManager, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, @DMNEditor DefaultCanvasCommandFactory canvasCommandFactory, Event<ExpressionEditorChanged> editorSelectedEvent, Event<RefreshFormPropertiesEvent> refreshFormPropertiesEvent, Event<DomainObjectSelectionEvent> domainObjectSelectionEvent, ListSelectorView.Presenter listSelector, TranslationService translationService, @DMNEditor Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier, @FunctionGridSupplementaryEditor Supplier<ExpressionEditorDefinitions> supplementaryEditorDefinitionsSupplier, ValueAndDataTypePopoverView.Presenter headerEditor, ParametersPopoverView.Presenter parametersEditor, KindPopoverView.Presenter kindEditor) {
        super(definitionUtils, sessionManager, sessionCommandManager, canvasCommandFactory, editorSelectedEvent, refreshFormPropertiesEvent, domainObjectSelectionEvent, listSelector, translationService);
        this.expressionEditorDefinitionsSupplier = expressionEditorDefinitionsSupplier;
        this.supplementaryEditorDefinitionsSupplier = supplementaryEditorDefinitionsSupplier;
        this.headerEditor = headerEditor;
        this.parametersEditor = parametersEditor;
        this.kindEditor = kindEditor;
    }

    @Override
    public ExpressionType getType() {
        return ExpressionType.FUNCTION;
    }

    @Override
    public String getName() {
        return this.translationService.format("ExpressionEditor.FunctionType", new Object[0]);
    }

    @Override
    public Optional<FunctionDefinition> getModelClass() {
        return Optional.of(new FunctionDefinition());
    }

    @Override
    public void enrich(Optional<String> nodeUUID, HasExpression hasExpression, Optional<FunctionDefinition> expression) {
        expression.ifPresent(function -> {
            KindUtilities.setKind(function, FunctionDefinition.Kind.FEEL);
            LiteralExpression le = new LiteralExpression();
            function.setExpression((Expression)le);
            le.setParent((DMNModelInstrumentedBase)function);
        });
    }

    @Override
    public Optional<BaseExpressionGrid<? extends Expression, ? extends GridData, ? extends BaseUIModelMapper>> getEditor(GridCellTuple parent, Optional<String> nodeUUID, HasExpression hasExpression, Optional<HasName> hasName, boolean isOnlyVisualChangeAllowed, int nesting) {
        return Optional.of(new FunctionGrid(parent, nodeUUID, hasExpression, hasName, this.getGridPanel(), this.getGridLayer(), this.makeGridData(() -> Optional.ofNullable((FunctionDefinition)hasExpression.getExpression())), this.definitionUtils, this.sessionManager, (SessionCommandManager<AbstractCanvasHandler>)this.sessionCommandManager, this.canvasCommandFactory, (Event<ExpressionEditorChanged>)this.editorSelectedEvent, (Event<RefreshFormPropertiesEvent>)this.refreshFormPropertiesEvent, (Event<DomainObjectSelectionEvent>)this.domainObjectSelectionEvent, this.getCellEditorControls(), this.listSelector, this.translationService, isOnlyVisualChangeAllowed, nesting, this.expressionEditorDefinitionsSupplier, this.supplementaryEditorDefinitionsSupplier, this.headerEditor, this.parametersEditor, this.kindEditor));
    }

    @Override
    protected DMNGridData makeGridData(Supplier<Optional<FunctionDefinition>> expression) {
        return new DMNGridData();
    }
}

