/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.imports.persistence;

import java.util.Map;
import java.util.Optional;

public class NamespaceHandler {
    static final String INCLUDED_NAMESPACE = "included";

    public static String addIncludedNamespace(Map<String, String> nsContext, String namespace) {
        Optional<Map.Entry<String, String>> existingNamespace = NamespaceHandler.getAlias(nsContext, namespace);
        if (existingNamespace.isPresent()) {
            return existingNamespace.get().getKey();
        }
        String alias = NamespaceHandler.getFreeIncludedNamespaceId(nsContext);
        nsContext.put(alias, namespace);
        return alias;
    }

    static String getFreeIncludedNamespaceId(Map<String, String> nsContext) {
        int includedNamespaces = (int)nsContext.keySet().stream().filter(k -> k.startsWith(INCLUDED_NAMESPACE)).count();
        String freeAliasCandidate = "included1";
        for (int i = 1; i <= includedNamespaces; ++i) {
            if (!nsContext.containsKey(freeAliasCandidate)) {
                return freeAliasCandidate;
            }
            freeAliasCandidate = INCLUDED_NAMESPACE + (i + 1);
        }
        return freeAliasCandidate;
    }

    static void removeIncludedNamespace(Map<String, String> nsContext, String namespace) {
        Optional<Map.Entry<String, String>> namespaceToRemove = NamespaceHandler.getAlias(nsContext, namespace);
        namespaceToRemove.ifPresent(stringStringEntry -> {
            String cfr_ignored_0 = (String)nsContext.remove(stringStringEntry.getKey());
        });
    }

    public static Optional<Map.Entry<String, String>> getAlias(Map<String, String> nsContext, String namespace) {
        return nsContext.entrySet().stream().filter(k -> ((String)k.getValue()).equals(namespace)).findFirst();
    }
}

