/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.imports.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.model.Context;
import org.kie.workbench.common.dmn.api.definition.model.ContextEntry;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.model.IsLiteralExpression;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.client.editors.included.imports.persistence.DRGElementHandler;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.ExpressionGridCache;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.util.StringUtils;

@Dependent
public class PMMLIncludedModelHandler
implements DRGElementHandler {
    private final DMNGraphUtils dmnGraphUtils;
    private final ExpressionGridCache expressionGridCache;

    @Inject
    public PMMLIncludedModelHandler(DMNGraphUtils dmnGraphUtils, SessionManager sessionManager) {
        this.dmnGraphUtils = dmnGraphUtils;
        this.expressionGridCache = ((DMNSession)sessionManager.getCurrentSession()).getExpressionGridCache();
    }

    @Override
    public void update(String oldModelName, String newModelName) {
        List<Decision> decisions = this.getDecisions();
        List<BusinessKnowledgeModel> businessKnowledgeModels = this.getBusinessKnowledgeModels();
        List<FunctionDefinition> functions = this.getPMMLFunctionDefinitions(decisions, businessKnowledgeModels);
        Collection<Context> contexts = this.getPMMLContexts(functions).values();
        String quotedOldModelName = StringUtils.createQuotedString((String)oldModelName);
        String quotedNewModelName = StringUtils.createQuotedString((String)newModelName);
        contexts.stream().map(Context::getContextEntry).flatMap(Collection::stream).filter(ce -> Objects.equals("document", ce.getVariable().getName().getValue())).filter(ce -> ce.getExpression() instanceof IsLiteralExpression).map(ce -> (IsLiteralExpression)ce.getExpression()).filter(ile -> Objects.nonNull(ile.getText())).map(IsLiteralExpression::getText).filter(text -> Objects.equals(quotedOldModelName, text.getValue())).forEach(text -> text.setValue(quotedNewModelName));
        this.refreshCachedExpressionGrids(decisions, businessKnowledgeModels);
    }

    @Override
    public void destroy(String oldModelName) {
        List<Decision> decisions = this.getDecisions();
        List<BusinessKnowledgeModel> businessKnowledgeModels = this.getBusinessKnowledgeModels();
        List<FunctionDefinition> functions = this.getPMMLFunctionDefinitions(decisions, businessKnowledgeModels);
        Map<FunctionDefinition, Context> contexts = this.getPMMLContexts(functions);
        String quotedOldModelName = StringUtils.createQuotedString((String)oldModelName);
        for (Map.Entry<FunctionDefinition, Context> entry : contexts.entrySet()) {
            Context context = entry.getValue();
            for (ContextEntry contextEntry : context.getContextEntry()) {
                Text text;
                IsLiteralExpression ile;
                Expression expression;
                if (!Objects.equals("document", contextEntry.getVariable().getName().getValue()) || !((expression = contextEntry.getExpression()) instanceof IsLiteralExpression) || !Objects.nonNull((ile = (IsLiteralExpression)expression).getText()) || !Objects.equals(quotedOldModelName, (text = ile.getText()).getValue())) continue;
                this.clearContextValues(context);
                entry.getKey().getFormalParameter().clear();
            }
        }
        this.refreshCachedExpressionGrids(decisions, businessKnowledgeModels);
    }

    private List<Decision> getDecisions() {
        return this.dmnGraphUtils.getDRGElements().stream().filter(e -> e instanceof Decision).map(e -> (Decision)e).collect(Collectors.toList());
    }

    private List<BusinessKnowledgeModel> getBusinessKnowledgeModels() {
        return this.dmnGraphUtils.getDRGElements().stream().filter(e -> e instanceof BusinessKnowledgeModel).map(e -> (BusinessKnowledgeModel)e).collect(Collectors.toList());
    }

    private List<FunctionDefinition> getPMMLFunctionDefinitions(List<Decision> decisions, List<BusinessKnowledgeModel> businessKnowledgeModels) {
        ArrayList<FunctionDefinition> functions = new ArrayList<FunctionDefinition>();
        functions.addAll(decisions.stream().map(d -> this.extractPMMLFunctionsFromExpression(d.getExpression())).flatMap(Collection::stream).collect(Collectors.toList()));
        functions.addAll(businessKnowledgeModels.stream().map(bkm -> this.extractPMMLFunctionsFromExpression((Expression)bkm.getEncapsulatedLogic())).flatMap(Collection::stream).collect(Collectors.toList()));
        return functions;
    }

    private List<FunctionDefinition> extractPMMLFunctionsFromExpression(Expression expression) {
        if (expression instanceof FunctionDefinition) {
            FunctionDefinition function = (FunctionDefinition)expression;
            if (Objects.equals(function.getKind(), FunctionDefinition.Kind.PMML)) {
                return Collections.singletonList(function);
            }
            return this.extractPMMLFunctionsFromExpression(function.getExpression());
        }
        if (expression instanceof Context) {
            Context context = (Context)expression;
            return context.getContextEntry().stream().map(ce -> this.extractPMMLFunctionsFromExpression(ce.getExpression())).flatMap(Collection::stream).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private Map<FunctionDefinition, Context> getPMMLContexts(List<FunctionDefinition> functions) {
        return functions.stream().filter(f -> f.getExpression() instanceof Context).collect(Collectors.toMap(f -> f, f -> (Context)f.getExpression()));
    }

    private void clearContextValues(Context context) {
        context.getContextEntry().stream().filter(ce -> ce.getExpression() instanceof IsLiteralExpression).map(ce -> (IsLiteralExpression)ce.getExpression()).filter(ile -> Objects.nonNull(ile.getText())).map(IsLiteralExpression::getText).forEach(text -> text.setValue(""));
    }

    private void refreshCachedExpressionGrids(List<Decision> decisions, List<BusinessKnowledgeModel> businessKnowledgeModels) {
        ArrayList nodeUUIDs = new ArrayList();
        nodeUUIDs.addAll(decisions.stream().map(d -> d.getId().getValue()).collect(Collectors.toList()));
        nodeUUIDs.addAll(businessKnowledgeModels.stream().map(d -> d.getId().getValue()).collect(Collectors.toList()));
        nodeUUIDs.stream().map(this.expressionGridCache::getExpressionGrid).filter(Optional::isPresent).map(Optional::get).forEach(BaseExpressionGrid::initialiseUiCells);
    }
}

