/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.search;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.util.GridHighlightHelper;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.DefaultGridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLienzoPanel;

public class DMNGridHelper {
    private final SessionManager sessionManager;

    @Inject
    public DMNGridHelper(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void highlightCell(int row, int column, GridWidget gridWidget) {
        this.highlightHelper(gridWidget).withPaddingX(this.getIdColumnWidth(gridWidget, column)).withPaddingY(this.getHeaderRowHeight(gridWidget, row)).withPinnedGrid().highlight(row, column);
    }

    public void focusGridPanel() {
        this.getGridPanel().setFocus(true);
    }

    private double getIdColumnWidth(GridWidget gridWidget, int column) {
        List columns = gridWidget.getModel().getColumns();
        double headerColumnWidth = this.getWidth(columns, 0);
        double currentColumnWidth = this.getWidth(columns, column);
        return headerColumnWidth + currentColumnWidth;
    }

    private double getHeaderRowHeight(GridWidget gridWidget, int row) {
        List rows = gridWidget.getModel().getRows();
        double headerRowHeight = this.getHeight(rows, 0);
        double currentRowHeight = this.getHeight(rows, row);
        return headerRowHeight + currentRowHeight;
    }

    public void clearSelections() {
        this.getGridWidgets().forEach(gridWidget -> this.highlightHelper((GridWidget)gridWidget).clearSelections());
    }

    public void clearCellHighlights() {
        this.getGridWidgets().forEach(gridWidget -> this.highlightHelper((GridWidget)gridWidget).clearHighlight());
    }

    public Set<GridWidget> getGridWidgets() {
        return this.getDefaultGridLayer().getGridWidgets().stream().filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private DefaultGridLayer getDefaultGridLayer() {
        return this.getGridPanel().getDefaultGridLayer();
    }

    private DMNGridPanel getGridPanel() {
        return this.getCurrentSession().getGridPanel();
    }

    private DMNSession getCurrentSession() {
        return (DMNSession)this.sessionManager.getCurrentSession();
    }

    GridHighlightHelper highlightHelper(GridWidget gridWidget) {
        return new GridHighlightHelper((GridLienzoPanel)this.getGridPanel(), gridWidget);
    }

    private double getWidth(List<GridColumn<?>> columns, int index) {
        if (index < columns.size()) {
            return columns.get(index).getWidth();
        }
        return 0.0;
    }

    private double getHeight(List<GridRow> rows, int index) {
        if (index < rows.size()) {
            return rows.get(index).getHeight();
        }
        return 0.0;
    }
}

