/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.gwtbootstrap3.extras.select.client.ui.OptGroup;
import org.gwtbootstrap3.extras.select.client.ui.Option;
import org.gwtbootstrap3.extras.select.client.ui.Select;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.editors.types.DataTypeChangedEvent;
import org.kie.workbench.common.dmn.client.editors.types.DataTypePageTabActiveEvent;
import org.kie.workbench.common.dmn.client.editors.types.QNameConverter;
import org.kie.workbench.common.dmn.client.editors.types.common.ItemDefinitionUtils;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.forms.adf.definitions.DynamicReadOnly;

@Dependent
@Templated
public class DataTypePickerWidget
extends Composite
implements HasValue<QName>,
HasEnabled {
    static final String CSS_DISPLAY = "display";
    static final String CSS_DISPLAY_NONE = "none";
    static final Comparator<BuiltInType> BUILT_IN_TYPE_COMPARATOR = Comparator.comparing(o -> {
        if (o == BuiltInType.UNDEFINED) {
            return "";
        }
        return o.getName();
    });
    static final Comparator<ItemDefinition> ITEM_DEFINITION_COMPARATOR = Comparator.comparing(o -> o.getName().getValue());
    @DataField
    private Anchor typeButton;
    @DataField
    private Div manageContainer;
    @DataField
    private Span manageLabel;
    @DataField
    private Select typeSelector;
    private TranslationService translationService;
    private QNameConverter qNameConverter;
    private DMNGraphUtils dmnGraphUtils;
    private Event<DataTypePageTabActiveEvent> dataTypePageActiveEvent;
    private ItemDefinitionUtils itemDefinitionUtils;
    private QName type;
    private boolean enabled;
    private boolean modelAllowsOnlyVisualChange;

    public DataTypePickerWidget() {
    }

    @Inject
    public DataTypePickerWidget(Anchor typeButton, Div manageContainer, Span manageLabel, TranslationService translationService, QNameConverter qNameConverter, DMNGraphUtils dmnGraphUtils, Event<DataTypePageTabActiveEvent> dataTypePageActiveEvent, ItemDefinitionUtils itemDefinitionUtils) {
        this.typeButton = typeButton;
        this.manageContainer = manageContainer;
        this.manageLabel = manageLabel;
        this.translationService = translationService;
        this.typeSelector = (Select)GWT.create(Select.class);
        this.qNameConverter = qNameConverter;
        this.dmnGraphUtils = dmnGraphUtils;
        this.dataTypePageActiveEvent = dataTypePageActiveEvent;
        this.itemDefinitionUtils = itemDefinitionUtils;
        this.typeSelector.setShowTick(true);
        this.typeSelector.setLiveSearch(true);
        this.typeSelector.getElement().setAttribute("data-container", "body");
        this.typeSelector.refresh();
        this.typeSelector.setLiveSearchPlaceholder(translationService.getTranslation("TypePickerWidget.Choose"));
        this.manageLabel.setTextContent(translationService.getTranslation("TypePickerWidget.Manage"));
        this.typeSelector.addValueChangeHandler(event -> this.setValue(qNameConverter.toModelValue((String)event.getValue()), true));
    }

    public void setDMNModel(DMNModelInstrumentedBase dmnModel) {
        if (dmnModel instanceof DynamicReadOnly) {
            this.modelAllowsOnlyVisualChange = ((DynamicReadOnly)dmnModel).isAllowOnlyVisualChange();
            if (this.modelAllowsOnlyVisualChange) {
                this.enabled = false;
                this.typeSelector.setEnabled(false);
            }
        }
        this.qNameConverter.setDMNModel(dmnModel);
        this.populateTypeSelector();
    }

    void populateTypeSelector() {
        this.typeSelector.clear();
        this.addBuiltInTypes();
        this.addItemDefinitions();
        this.typeSelector.refresh();
        if (!Objects.isNull(this.getValue())) {
            this.setValue(this.getValue(), false);
        }
    }

    void addBuiltInTypes() {
        OptGroup group = (OptGroup)GWT.create(OptGroup.class);
        group.setLabel(this.translationService.getTranslation("DataTypeSelectView.DefaultTitle"));
        Stream.of(BuiltInType.values()).sorted(BUILT_IN_TYPE_COMPARATOR).map(this::makeTypeSelector).filter(Optional::isPresent).forEach(o -> group.add((Widget)o.get()));
        this.typeSelector.add((Widget)group);
    }

    Optional<Option> makeTypeSelector(BuiltInType bit) {
        Option o = (Option)GWT.create(Option.class);
        o.setText(bit.getName());
        o.setValue(this.qNameConverter.toWidgetValue(this.normaliseBuiltInTypeTypeRef(bit.asQName())));
        return Optional.of(o);
    }

    QName normaliseBuiltInTypeTypeRef(QName typeRef) {
        return this.itemDefinitionUtils.normaliseTypeRef(typeRef);
    }

    void addItemDefinitions() {
        Definitions definitions = this.dmnGraphUtils.getDefinitions();
        List itemDefinitions = definitions != null ? definitions.getItemDefinition() : Collections.emptyList();
        OptGroup group = (OptGroup)GWT.create(OptGroup.class);
        group.setLabel(this.translationService.getTranslation("DataTypeSelectView.CustomTitle"));
        itemDefinitions.stream().sorted(ITEM_DEFINITION_COMPARATOR).map(this::makeTypeSelector).filter(Optional::isPresent).forEach(o -> group.add((Widget)o.get()));
        this.typeSelector.add((Widget)group);
    }

    Optional<Option> makeTypeSelector(ItemDefinition id) {
        Option o = null;
        if (id.getName() != null) {
            Name name = id.getName();
            o = (Option)GWT.create(Option.class);
            o.setText(name.getValue());
            o.setValue(this.qNameConverter.toWidgetValue(new QName("", name.getValue(), "")));
        }
        return Optional.ofNullable(o);
    }

    public void onDataTypePageNavTabActiveEvent(@Observes DataTypeChangedEvent event) {
        this.populateTypeSelector();
    }

    @EventHandler(value={"typeButton"})
    public void onClickTypeButton(ClickEvent clickEvent) {
        this.dataTypePageActiveEvent.fire((Object)new DataTypePageTabActiveEvent());
    }

    public void showManageLabel() {
        this.manageContainer.getStyle().removeProperty(CSS_DISPLAY);
    }

    public void hideManageLabel() {
        this.manageContainer.getStyle().setProperty(CSS_DISPLAY, CSS_DISPLAY_NONE);
    }

    public QName getValue() {
        return this.type;
    }

    public void setValue(QName value) {
        this.setValue(value, false);
    }

    public void setValue(QName value, boolean fireEvents) {
        QName oldValue = this.type;
        this.type = value;
        this.typeSelector.setValue((Object)this.qNameConverter.toWidgetValue(this.type), false);
        if (fireEvents) {
            this.fireValueChangeEvent(oldValue);
        }
    }

    void fireValueChangeEvent(QName oldValue) {
        ValueChangeEvent.fireIfNotEqual((HasValueChangeHandlers)this, (Object)oldValue, (Object)this.type);
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<QName> handler) {
        return this.addHandler((com.google.gwt.event.shared.EventHandler)handler, ValueChangeEvent.getType());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.modelAllowsOnlyVisualChange) {
            return;
        }
        this.enabled = enabled;
        this.typeSelector.setEnabled(enabled);
    }
}

