/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.dmn.api.definition.model.ConstraintType;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.editors.types.BuiltInTypeUtils;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManagerStackStore;
import org.kie.workbench.common.dmn.client.editors.types.common.ItemDefinitionUtils;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionRecordEngine;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionStore;
import org.kie.workbench.common.dmn.client.editors.types.persistence.validation.DataTypeNameValidator;
import org.uberfire.commons.uuid.UUID;

@Dependent
public class DataTypeManager {
    private final TranslationService translationService;
    private final ItemDefinitionRecordEngine recordEngine;
    private final ItemDefinitionStore itemDefinitionStore;
    private final DataTypeStore dataTypeStore;
    private final ItemDefinitionUtils itemDefinitionUtils;
    private final ManagedInstance<DataTypeManager> dataTypeManagers;
    private final DataTypeNameValidator dataTypeNameValidator;
    private final DataTypeManagerStackStore typeStack;
    private DataType dataType;
    private ItemDefinition itemDefinition;

    @Inject
    public DataTypeManager(TranslationService translationService, ItemDefinitionRecordEngine recordEngine, ItemDefinitionStore itemDefinitionStore, DataTypeStore dataTypeStore, ItemDefinitionUtils itemDefinitionUtils, ManagedInstance<DataTypeManager> dataTypeManagers, DataTypeNameValidator dataTypeNameValidator, DataTypeManagerStackStore typeStack) {
        this.translationService = translationService;
        this.recordEngine = recordEngine;
        this.itemDefinitionStore = itemDefinitionStore;
        this.dataTypeStore = dataTypeStore;
        this.itemDefinitionUtils = itemDefinitionUtils;
        this.dataTypeManagers = dataTypeManagers;
        this.dataTypeNameValidator = dataTypeNameValidator;
        this.typeStack = typeStack;
    }

    public DataTypeManager fromNew() {
        return this.newDataType().withUUID().withParentUUID("").withNoName().withNoConstraint().asList(false).withDefaultType();
    }

    public DataTypeManager from(ItemDefinition itemDefinition) {
        boolean isReadOnly = itemDefinition.isImported();
        return this.newDataType(isReadOnly).withUUID().withParentUUID("").withItemDefinition(itemDefinition).withItemDefinitionName().withItemDefinitionType().withItemDefinitionConstraint().withItemDefinitionCollection().withItemDefinitionSubDataTypes().withIndexedItemDefinition();
    }

    public DataTypeManager from(BuiltInType builtInType) {
        return this.newDataType().withUUID().withName(this.none()).withBuiltInType(builtInType);
    }

    public DataTypeManager from(DataType dataType) {
        return this.withDataType(dataType).withItemDefinition(this.getItemDefinition(dataType));
    }

    public DataTypeManager withParentUUID(String parentUUID) {
        this.dataType.setParentUUID(parentUUID);
        return this;
    }

    public DataTypeManager withName(String name) {
        this.dataType.setName(name);
        return this;
    }

    public DataTypeManager withType(String type) {
        this.dataType.setType(type);
        return this;
    }

    public DataTypeManager withConstraint(String constraint) {
        this.dataType.setConstraint(constraint);
        return this;
    }

    public DataTypeManager withConstraintType(String constraintType) {
        this.dataType.setConstraintType(ConstraintType.fromString((String)constraintType));
        return this;
    }

    public DataTypeManager asList(boolean isCollection) {
        this.dataType.setAsList(isCollection);
        return this;
    }

    public DataTypeManager withNoConstraint() {
        return this.withConstraint("");
    }

    public DataTypeManager withDataType(DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    private DataTypeManager withDefaultType() {
        return this.withType(BuiltInType.ANY.getName());
    }

    DataTypeManager newDataType() {
        return this.withDataType(new DataType(this.recordEngine));
    }

    DataTypeManager newReadOnlyDataType() {
        return this.withDataType(new DataType(null));
    }

    DataTypeManager newDataType(boolean isReadOnly) {
        return isReadOnly ? this.newReadOnlyDataType() : this.newDataType();
    }

    public DataTypeManager withItemDefinition(ItemDefinition itemDefinition) {
        this.itemDefinition = (ItemDefinition)PortablePreconditions.checkNotNull((String)"itemDefinition", (Object)itemDefinition);
        return this;
    }

    private DataTypeManager withBuiltInType(BuiltInType builtInType) {
        String type = ((BuiltInType)PortablePreconditions.checkNotNull((String)"builtInType", (Object)builtInType)).getName();
        return this.withType(type);
    }

    public DataTypeManager withRefreshedSubDataTypes(String newType) {
        return this.withSubDataTypes(this.makeExternalDataTypes(newType));
    }

    public DataTypeManager withSubDataTypes(List<DataType> dataTypes) {
        if (!this.isReadOnly(this.dataType)) {
            this.dataType.getSubDataTypes().forEach(dataType -> {
                this.dataTypeStore.unIndex(dataType.getUUID());
                this.itemDefinitionStore.unIndex(dataType.getUUID());
            });
            this.dataType.setSubDataTypes(dataTypes);
        }
        return this;
    }

    private boolean isReadOnly(DataType dataType) {
        return dataType.isReadOnly() || this.isReadyOnlyType(dataType.getType());
    }

    private boolean isReadyOnlyType(String type) {
        return this.itemDefinitionUtils.findByName(type).map(ItemDefinition::isAllowOnlyVisualChange).orElse(false);
    }

    DataTypeManager withUUID() {
        this.dataType.setUUID(UUID.uuid());
        return this;
    }

    public DataTypeManager withNoName() {
        return this.withName(this.none());
    }

    public DataTypeManager withUniqueName() {
        return this.withUniqueName(this.dataType.getName());
    }

    public DataTypeManager withUniqueName(String name) {
        return this.withUniqueName(name, 1);
    }

    private DataTypeManager withUniqueName(String name, int nameSuffix) {
        this.withName(nameSuffix == 1 ? name : name + " - " + nameSuffix);
        if (this.dataTypeNameValidator.isNotUnique(this.get())) {
            return this.withUniqueName(name, nameSuffix + 1);
        }
        return this;
    }

    DataTypeManager withItemDefinitionName() {
        return this.withName(this.itemDefinitionName(this.itemDefinition));
    }

    DataTypeManager withItemDefinitionConstraint() {
        DataTypeManager dt = this.withConstraint(this.itemDefinitionUtils.getConstraintText(this.itemDefinition));
        if (this.itemDefinition.getAllowedValues() != null && this.itemDefinition.getAllowedValues().getConstraintType() != null) {
            return dt.withConstraintType(this.itemDefinition.getAllowedValues().getConstraintType().value());
        }
        return dt;
    }

    DataTypeManager withItemDefinitionCollection() {
        return this.asList(this.itemDefinition.isIsCollection());
    }

    DataTypeManager withItemDefinitionType() {
        return this.withType(this.itemDefinitionType(this.itemDefinition));
    }

    public DataTypeManager withItemDefinitionSubDataTypes() {
        return this.withSubDataTypes(this.createSubDataTypesFromItemDefinition());
    }

    public DataTypeManager withIndexedItemDefinition() {
        this.itemDefinitionStore.index(this.dataType.getUUID(), this.itemDefinition);
        this.dataTypeStore.index(this.dataType.getUUID(), this.dataType);
        return this;
    }

    public DataType get() {
        return this.dataType;
    }

    private String itemDefinitionName(ItemDefinition itemDefinition) {
        Optional<Name> name = Optional.ofNullable(itemDefinition.getName());
        return name.isPresent() ? name.get().getValue() : this.none();
    }

    private String itemDefinitionType(ItemDefinition itemDefinition) {
        Optional<QName> typeRef = Optional.ofNullable(itemDefinition.getTypeRef());
        return typeRef.isPresent() ? typeRef.get().getLocalPart() : this.structure();
    }

    private ItemDefinition getItemDefinition(DataType dataType) {
        Optional<ItemDefinition> itemDefinition = Optional.ofNullable(this.itemDefinitionStore.get(dataType.getUUID()));
        return itemDefinition.orElseThrow(() -> new UnsupportedOperationException("The data type must have an indexed ItemDefinition."));
    }

    private List<DataType> createSubDataTypesFromItemDefinition() {
        List itemComponent = this.itemDefinition.getItemComponent();
        String type = this.itemDefinitionType(this.itemDefinition);
        Optional<ItemDefinition> existingItemDefinition = this.itemDefinitionUtils.findByName(type);
        boolean existingDataType = existingItemDefinition.isPresent();
        if (this.isTypeAlreadyRepresented(type)) {
            return new ArrayList<DataType>();
        }
        if (itemComponent.isEmpty()) {
            return this.createSubDataTypes(existingDataType ? existingItemDefinition.get().getItemComponent() : new ArrayList());
        }
        return this.createSubDataTypes(itemComponent);
    }

    public List<DataType> makeExternalDataTypes(String typeName) {
        Optional<ItemDefinition> existingItemDefinition = this.itemDefinitionUtils.findByName(typeName);
        if (this.isTypeAlreadyRepresented(typeName) || !existingItemDefinition.isPresent()) {
            return new ArrayList<DataType>();
        }
        return existingItemDefinition.get().getItemComponent().stream().map(this::createSubDataType).collect(Collectors.toList());
    }

    ItemDefinition getItemDefinitionWithItemComponent(ItemDefinition itemDefinition) {
        Optional<ItemDefinition> definition;
        if (itemDefinition.getTypeRef() != null && (definition = this.findByName(this.itemDefinitionType(itemDefinition))).isPresent()) {
            return this.getItemDefinitionWithItemComponent(definition.get());
        }
        return itemDefinition;
    }

    public String structure() {
        return this.translationService.format("DataTypeManager.Structure", new Object[0]);
    }

    public String getTypeName() {
        String type = this.dataType.getType();
        String name = this.dataType.getName();
        String structure = this.structure();
        if (Objects.equals(type, structure)) {
            return name;
        }
        return type;
    }

    private List<DataType> createSubDataTypes(List<ItemDefinition> itemComponent) {
        return itemComponent.stream().map(this::createSubDataType).collect(Collectors.toList());
    }

    DataType createSubDataType(ItemDefinition itemDefinition) {
        return this.anotherManager().newDataType(this.getDataType().isReadOnly()).withUUID().withParentUUID(this.getDataTypeUUID().orElseThrow(() -> new UnsupportedOperationException("A parent data type must have an UUID."))).withItemDefinition(itemDefinition).withItemDefinitionName().withItemDefinitionType().withItemDefinitionConstraint().withItemDefinitionCollection().withTypeStack(this.getSubDataTypeStack()).withItemDefinitionSubDataTypes().withIndexedItemDefinition().get();
    }

    private String none() {
        return this.translationService.format("DataTypeManager.None", new Object[0]);
    }

    public DataTypeManager asStructure() {
        return this.withType(this.structure());
    }

    DataTypeManager anotherManager() {
        return (DataTypeManager)this.dataTypeManagers.get();
    }

    Optional<String> getDataTypeUUID() {
        return Optional.ofNullable(this.getDataType().getUUID());
    }

    boolean isTypeAlreadyRepresented(String type) {
        return this.getTypeStack().contains(type);
    }

    List<String> getSubDataTypeStack() {
        ArrayList<String> subDataTypeStack = new ArrayList<String>(this.getTypeStack());
        this.getStackType().ifPresent(subDataTypeStack::add);
        return subDataTypeStack;
    }

    DataTypeManager withTypeStack(List<String> typeStack) {
        String dataTypeUUID = this.getDataTypeUUID().orElseThrow(() -> new UnsupportedOperationException("A data type must have an UUID to be inserted in the type stack."));
        this.typeStack.put(dataTypeUUID, typeStack);
        return this;
    }

    Optional<String> getStackType() {
        String type = this.getDataType().getType();
        String name = this.getDataType().getName();
        if (this.getDataType().isTopLevel()) {
            return Optional.ofNullable(name);
        }
        if (!Objects.equals(type, this.structure()) && !BuiltInTypeUtils.isBuiltInType((String)type)) {
            return Optional.ofNullable(type);
        }
        return Optional.empty();
    }

    private List<String> getTypeStack() {
        String dataTypeUUID = this.getDataTypeUUID().orElseThrow(() -> new UnsupportedOperationException("A data type must have an UUID to be access the type stack."));
        return this.typeStack.get(dataTypeUUID);
    }

    DataType getDataType() {
        return this.dataType;
    }

    private Optional<ItemDefinition> findByName(String typeName) {
        return this.itemDefinitionUtils.findByName(typeName);
    }

    public Optional<DataType> getTopLevelDataTypeWithName(String typeName) {
        return this.findTopLevelDataTypeWithName(typeName);
    }

    Optional<DataType> findTopLevelDataTypeWithName(String typeName) {
        return this.dataTypeStore.getTopLevelDataTypes().stream().filter(data -> Objects.equals(data.getName(), typeName)).findFirst();
    }
}

