/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.imported.treelist;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.Element;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import java.util.Objects;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.client.editors.types.common.HiddenHelper;
import org.kie.workbench.common.dmn.client.editors.types.imported.treelist.TreeListItem;
import org.kie.workbench.common.dmn.client.editors.types.imported.treelist.TreeListSubItem;

@Dependent
@Templated
public class TreeListItemView
implements TreeListItem.View {
    private TreeListItem presenter;
    @DataField(value="item-header")
    private final HTMLDivElement itemHeader;
    @DataField(value="items-container")
    private final HTMLDivElement itemsContainer;
    @DataField(value="item-details")
    private final HTMLDivElement itemDetails;
    @DataField(value="item-root")
    private final HTMLDivElement itemRoot;
    @DataField(value="expand-container")
    private final HTMLDivElement expandContainer;
    @DataField(value="expand")
    private final HTMLElement expand;
    @DataField(value="data-object-checkbox")
    private final HTMLInputElement checkbox;

    @Inject
    public TreeListItemView(HTMLDivElement itemHeader, HTMLDivElement itemsContainer, HTMLDivElement itemDetails, HTMLDivElement expandContainer, @Named(value="span") HTMLElement expand, HTMLInputElement checkbox, HTMLDivElement itemRoot) {
        this.itemHeader = itemHeader;
        this.itemsContainer = itemsContainer;
        this.itemDetails = itemDetails;
        this.expandContainer = expandContainer;
        this.expand = expand;
        this.checkbox = checkbox;
        this.itemRoot = itemRoot;
    }

    public TreeListItem getPresenter() {
        return this.presenter;
    }

    public void init(TreeListItem presenter) {
        this.presenter = presenter;
    }

    @EventHandler(value={"data-object-checkbox"})
    public void onCheckboxChanged(ChangeEvent valueChanged) {
        this.getPresenter().setIsSelected(this.checkbox.checked);
    }

    @EventHandler(value={"item-header"})
    public void onClick(ClickEvent e) {
        Object target = this.getTarget(e);
        if (Objects.equals(target, this.checkbox)) {
            return;
        }
        if (HiddenHelper.isHidden((Element)this.itemsContainer)) {
            this.showElement((HTMLElement)this.itemsContainer);
        } else {
            this.hideElement((HTMLElement)this.itemsContainer);
        }
    }

    void showElement(HTMLElement element) {
        HiddenHelper.show((Element)element);
    }

    void hideElement(HTMLElement element) {
        HiddenHelper.hide((Element)element);
    }

    Object getTarget(ClickEvent event) {
        return com.google.gwt.dom.client.Element.as((JavaScriptObject)event.getNativeEvent().getEventTarget());
    }

    @Override
    public void populate(TreeListItem item) {
        this.checkbox.checked = item.getIsSelected();
        this.itemDetails.textContent = item.getDescription();
        this.addSubItems(item);
        this.setExpandVisibility(item);
    }

    void setExpandVisibility(TreeListItem item) {
        if (item.getSubItems().isEmpty()) {
            this.hideElement(this.expand);
        } else {
            this.showElement(this.expand);
        }
    }

    void addSubItems(TreeListItem item) {
        for (TreeListSubItem sub : item.getSubItems()) {
            this.itemsContainer.appendChild(sub.getElement());
        }
    }

    public HTMLElement getElement() {
        return this.itemRoot;
    }
}

