/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.day.time;

import com.google.gwt.event.dom.client.BlurEvent;
import elemental2.dom.Element;
import elemental2.dom.Event;
import elemental2.dom.HTMLInputElement;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.common.MinMaxValueHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.day.time.DayTimeSelector;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.day.time.DayTimeValue;

@Templated
public class DayTimeSelectorView
implements DayTimeSelector.View {
    @DataField(value="days-input")
    private final HTMLInputElement daysInput;
    @DataField(value="hours-input")
    private final HTMLInputElement hoursInput;
    @DataField(value="minutes-input")
    private final HTMLInputElement minutesInput;
    @DataField(value="seconds-input")
    private final HTMLInputElement secondsInput;
    private Consumer<Event> onValueChangedConsumer;
    private Consumer<BlurEvent> onValueInputBlurConsumer;
    private DayTimeSelector presenter;

    @Inject
    public DayTimeSelectorView(HTMLInputElement daysInput, HTMLInputElement hoursInput, HTMLInputElement minutesInput, HTMLInputElement secondsInput) {
        this.daysInput = daysInput;
        this.hoursInput = hoursInput;
        this.minutesInput = minutesInput;
        this.secondsInput = secondsInput;
    }

    public void init(DayTimeSelector presenter) {
        this.presenter = presenter;
    }

    @PostConstruct
    public void setupEventHandlers() {
        MinMaxValueHelper.setupMinMaxHandlers(this.daysInput);
        MinMaxValueHelper.setupMinMaxHandlers(this.hoursInput);
        MinMaxValueHelper.setupMinMaxHandlers(this.minutesInput);
        MinMaxValueHelper.setupMinMaxHandlers(this.secondsInput);
        this.daysInput.onchange = this.getOnChangeHandler();
        this.hoursInput.onchange = this.getOnChangeHandler();
        this.minutesInput.onchange = this.getOnChangeHandler();
        this.secondsInput.onchange = this.getOnChangeHandler();
    }

    @Override
    public DayTimeValue getValue() {
        DayTimeValue value = new DayTimeValue();
        value.setDays(MinMaxValueHelper.toInteger(this.daysInput.value, DayTimeValue.NONE));
        value.setHours(MinMaxValueHelper.toInteger(this.hoursInput.value, DayTimeValue.NONE));
        value.setMinutes(MinMaxValueHelper.toInteger(this.minutesInput.value, DayTimeValue.NONE));
        value.setSeconds(MinMaxValueHelper.toInteger(this.secondsInput.value, DayTimeValue.NONE));
        return value;
    }

    @Override
    public void setValue(DayTimeValue value) {
        this.daysInput.value = this.toDisplay(value.getDays());
        this.hoursInput.value = this.toDisplay(value.getHours());
        this.minutesInput.value = this.toDisplay(value.getMinutes());
        this.secondsInput.value = this.toDisplay(value.getSeconds());
    }

    @Override
    public void setOnValueChanged(Consumer<Event> onValueChangedConsumer) {
        this.onValueChangedConsumer = onValueChangedConsumer;
    }

    @Override
    public void setOnValueInputBlur(Consumer<BlurEvent> onValueInputBlurConsumer) {
        this.onValueInputBlurConsumer = onValueInputBlurConsumer;
    }

    @EventHandler(value={"days-input"})
    public void onDaysInputBlurEvent(BlurEvent blurEvent) {
        this.onBlurHandler(blurEvent);
    }

    @EventHandler(value={"hours-input"})
    public void onHoursInputBlurEvent(BlurEvent blurEvent) {
        this.onBlurHandler(blurEvent);
    }

    @EventHandler(value={"minutes-input"})
    public void onMinutesInputBlurEvent(BlurEvent blurEvent) {
        this.onBlurHandler(blurEvent);
    }

    @EventHandler(value={"seconds-input"})
    public void onSecondsInputBlurEvent(BlurEvent blurEvent) {
        this.onBlurHandler(blurEvent);
    }

    @Override
    public void select() {
        this.daysInput.select();
    }

    Element.OnchangeFn getOnChangeHandler() {
        return e -> {
            this.getOnValueChangedConsumer().ifPresent(consumer -> consumer.accept(e));
            return true;
        };
    }

    void onBlurHandler(BlurEvent blurEvent) {
        if (!this.isDayTimeInput(this.getEventTarget(blurEvent))) {
            this.getOnValueInputBlurConsumer().ifPresent(consumer -> consumer.accept(blurEvent));
        }
    }

    Object getEventTarget(BlurEvent blurEvent) {
        return blurEvent.getNativeEvent().getRelatedEventTarget();
    }

    Optional<Consumer<BlurEvent>> getOnValueInputBlurConsumer() {
        return Optional.ofNullable(this.onValueInputBlurConsumer);
    }

    Optional<Consumer<Event>> getOnValueChangedConsumer() {
        return Optional.ofNullable(this.onValueChangedConsumer);
    }

    private boolean isDayTimeInput(Object element) {
        return Arrays.asList(this.daysInput, this.hoursInput, this.minutesInput, this.secondsInput).contains(element);
    }

    private String toDisplay(Integer value) {
        return Objects.isNull(value) || Objects.equals(value, 0) ? "" : value.toString();
    }
}

