/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.persistence.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionStore;
import org.kie.workbench.common.dmn.client.editors.types.persistence.handlers.common.PropertiesPanelNotifier;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;

@Dependent
public class ItemDefinitionDestroyHandler {
    private final ItemDefinitionStore itemDefinitionStore;
    private final DMNGraphUtils dmnGraphUtils;
    private final PropertiesPanelNotifier panelNotifier;

    @Inject
    public ItemDefinitionDestroyHandler(ItemDefinitionStore itemDefinitionStore, DMNGraphUtils dmnGraphUtils, PropertiesPanelNotifier panelNotifier) {
        this.itemDefinitionStore = itemDefinitionStore;
        this.dmnGraphUtils = dmnGraphUtils;
        this.panelNotifier = panelNotifier;
    }

    public void destroy(DataType dataType, boolean notifyPropertiesPanel) {
        ItemDefinition itemDefinition = this.findItemDefinition(dataType);
        String destroyedItemDefinition = itemDefinition.getName().getValue();
        Optional<ItemDefinition> itemDefinitionParent = this.findItemDefinitionParent(dataType);
        itemDefinitionParent.ifPresent(parent -> parent.getItemComponent().remove(itemDefinition));
        this.itemDefinitions().remove(itemDefinition);
        this.itemDefinitionStore.unIndex(dataType.getUUID());
        if (notifyPropertiesPanel) {
            this.notifyPropertiesPanel(destroyedItemDefinition);
        }
    }

    void notifyPropertiesPanel(String destroyedItemDefinition) {
        this.panelNotifier.withOldLocalPart(destroyedItemDefinition).withNewQName(new QName()).notifyPanel();
    }

    Optional<ItemDefinition> findItemDefinitionParent(DataType dataType) {
        Optional<ItemDefinition> itemDefinitionParent = Optional.ofNullable(this.itemDefinitionStore.get(dataType.getParentUUID()));
        if (itemDefinitionParent.isPresent()) {
            ItemDefinition parent = itemDefinitionParent.get();
            if (parent.getTypeRef() == null) {
                return Optional.of(parent);
            }
            for (ItemDefinition itemDefinition : this.itemDefinitions()) {
                if (!Objects.equals(itemDefinition.getName().getValue(), parent.getTypeRef().getLocalPart())) continue;
                return Optional.of(itemDefinition);
            }
        }
        return Optional.empty();
    }

    List<ItemDefinition> itemDefinitions() {
        Optional<Definitions> definitions = Optional.ofNullable(this.dmnGraphUtils.getDefinitions());
        if (definitions.isPresent()) {
            return definitions.get().getItemDefinition();
        }
        return new ArrayList<ItemDefinition>();
    }

    private ItemDefinition findItemDefinition(DataType dataType) {
        return this.itemDefinitionStore.get(dataType.getUUID());
    }
}

