/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.search;

import elemental2.dom.Element;
import elemental2.dom.HTMLElement;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.HiddenHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeList;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDListComponent;
import org.kie.workbench.common.dmn.client.editors.types.search.DataTypeSearchEngine;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.uberfire.client.mvp.UberElemental;

@ApplicationScoped
public class DataTypeSearchBar {
    private final View view;
    private final DataTypeSearchEngine searchEngine;
    private final DataTypeList dataTypeList;
    private String currentSearch;
    private final Map<String, Integer> dataTypeListPositionsStore = new HashMap<String, Integer>();
    private final Map<String, Boolean> dataTypeListCollapsedStatusStore = new HashMap<String, Boolean>();

    @Inject
    public DataTypeSearchBar(View view, DataTypeSearchEngine searchEngine, DataTypeList dataTypeList) {
        this.view = view;
        this.searchEngine = searchEngine;
        this.dataTypeList = dataTypeList;
    }

    @PostConstruct
    void setup() {
        this.view.init(this);
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    public void refresh() {
        this.search(this.getCurrentSearch());
    }

    public void reset() {
        this.setCurrentSearch("");
        this.dataTypeList.showListItems();
        this.view.resetSearchBar();
        this.restoreDataTypeListPositions();
    }

    void search(String keyword) {
        List<DataType> results = this.searchEngine.search(keyword);
        this.storeDataTypeListPositions();
        this.showEmptyView(results.isEmpty());
        this.setCurrentSearch(keyword);
        if (StringUtils.isEmpty((String)keyword)) {
            this.reset();
        } else {
            this.view.showSearchResults(results);
        }
    }

    HTMLElement getResultsContainer() {
        return this.dataTypeList.getElement();
    }

    String getCurrentSearch() {
        return this.currentSearch;
    }

    void setCurrentSearch(String currentSearch) {
        this.currentSearch = currentSearch;
    }

    DNDListComponent getDNDListComponent() {
        return this.dataTypeList.getDNDListComponent();
    }

    void restoreDataTypeListPositions() {
        if (!this.hasDataTypeListPositionsStored()) {
            return;
        }
        this.getDataTypeListItems().forEach(item -> {
            HTMLElement element = item.getDragAndDropElement();
            String uuid = item.getDataType().getUUID();
            Integer positionY = this.getDataTypeListPositionsStore().get(uuid);
            this.getDNDListComponent().setPositionY((Element)element, positionY.intValue());
            if (positionY > -1) {
                HiddenHelper.show((Element)element);
            } else {
                HiddenHelper.hide((Element)element);
            }
            boolean collapsed = this.getDataTypeListCollapsedStatusStore().get(uuid);
            if (collapsed) {
                item.collapse();
            }
        });
        this.getDNDListComponent().refreshItemsPosition();
        this.getDataTypeListPositionsStore().clear();
        this.getDataTypeListCollapsedStatusStore().clear();
    }

    void storeDataTypeListPositions() {
        if (this.hasDataTypeListPositionsStored()) {
            return;
        }
        this.getDataTypeListItems().forEach(listItem -> {
            String dataTypeUUID = listItem.getDataType().getUUID();
            Integer dataTypeYPosition = this.getDNDListComponent().getPositionY((Element)listItem.getDragAndDropElement());
            this.getDataTypeListCollapsedStatusStore().put(dataTypeUUID, listItem.isCollapsed());
            this.getDataTypeListPositionsStore().put(dataTypeUUID, dataTypeYPosition);
        });
    }

    Map<String, Integer> getDataTypeListPositionsStore() {
        return this.dataTypeListPositionsStore;
    }

    Map<String, Boolean> getDataTypeListCollapsedStatusStore() {
        return this.dataTypeListCollapsedStatusStore;
    }

    private boolean hasDataTypeListPositionsStored() {
        return !this.getDataTypeListPositionsStore().isEmpty();
    }

    private List<DataTypeListItem> getDataTypeListItems() {
        return this.dataTypeList.getItems();
    }

    private void showEmptyView(boolean show) {
        if (show) {
            this.dataTypeList.showNoDataTypesFound();
        } else {
            this.dataTypeList.showListItems();
        }
    }

    List<DataTypeListItem> getDataTypeListItemsSortedByPositionY() {
        return this.getDataTypeListItems().stream().sorted(Comparator.comparing(item -> this.getDNDListComponent().getPositionY((Element)item.getDragAndDropElement()))).collect(Collectors.toList());
    }

    public boolean isEnabled() {
        return !StringUtils.isEmpty((String)this.getCurrentSearch());
    }

    public static interface View
    extends UberElemental<DataTypeSearchBar>,
    IsElement {
        public void showSearchResults(List<DataType> var1);

        public void resetSearchBar();
    }
}

