/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.codecompletion;

import com.google.common.collect.ImmutableList;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.MonacoFEELVariableSuggestions;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.MonacoPropertiesFactory;
import org.uberfire.client.views.pfly.monaco.MonacoEditorInitializer;
import org.uberfire.client.views.pfly.monaco.jsinterop.Monaco;

@ApplicationScoped
public class MonacoFEELInitializer {
    public static final ImmutableList<String> FEEL_RESERVED_KEYWORDS = ImmutableList.of((Object)"for", (Object)"return", (Object)"if", (Object)"then", (Object)"else", (Object)"some", (Object)"every", (Object)"satisfies", (Object)"instance", (Object)"of", (Object)"in", (Object)"function", (Object[])new String[]{"external", "or", "and", "between", "not", "null", "true", "false"});
    private final MonacoFEELVariableSuggestions variableSuggestions;
    private MonacoFEELInitializationStatus initializationStatus = MonacoFEELInitializationStatus.NOT_INITIALIZED;

    @Inject
    public MonacoFEELInitializer(MonacoFEELVariableSuggestions variableSuggestions) {
        this.variableSuggestions = variableSuggestions;
    }

    public void initializeFEELEditor() {
        if (this.isFEELInitialized()) {
            return;
        }
        this.setFEELAsInitializing();
        this.makeMonacoEditorInitializer().require(this.onMonacoLoaded());
    }

    Consumer<Monaco> onMonacoLoaded() {
        MonacoPropertiesFactory properties = this.makeMonacoPropertiesFactory();
        return monaco -> {
            monaco.languages.register(properties.getLanguage());
            monaco.languages.setMonarchTokensProvider("feel-language", properties.getLanguageDefinition());
            monaco.languages.registerCompletionItemProvider("feel-language", properties.getCompletionItemProvider(this.variableSuggestions));
            monaco.editor.defineTheme("feel-theme", properties.getThemeData());
            this.setFEELAsInitialized();
        };
    }

    MonacoEditorInitializer makeMonacoEditorInitializer() {
        return new MonacoEditorInitializer();
    }

    MonacoPropertiesFactory makeMonacoPropertiesFactory() {
        return new MonacoPropertiesFactory();
    }

    void setFEELAsInitialized() {
        this.initializationStatus = MonacoFEELInitializationStatus.INITIALIZED;
    }

    void setFEELAsInitializing() {
        this.initializationStatus = MonacoFEELInitializationStatus.INITIALIZING;
    }

    boolean isFEELInitialized() {
        return MonacoFEELInitializationStatus.INITIALIZED == this.getInitializationStatus() || MonacoFEELInitializationStatus.INITIALIZING == this.getInitializationStatus();
    }

    public MonacoFEELInitializationStatus getInitializationStatus() {
        return this.initializationStatus;
    }

    static enum MonacoFEELInitializationStatus {
        NOT_INITIALIZED,
        INITIALIZING,
        INITIALIZED;

    }
}

