/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid;

import com.ait.lienzo.client.core.event.INodeXYEvent;
import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.enterprise.event.Event;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.HasValue;
import org.kie.workbench.common.dmn.api.definition.NOPDomainObject;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.dmn.client.commands.general.DeleteCellValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.DeleteHasValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.DeleteHeaderValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetCellValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetHasValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetHeaderValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetTypeRefCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.ExpressionGridCache;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditableHeaderMetaData;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.AutocompleteTextAreaDOMElementFactory;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.ListBoxSingletonDOMElementFactory;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.TextAreaSingletonDOMElementFactory;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.TextBoxSingletonDOMElementFactory;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.handlers.EditableHeaderGridWidgetEditCellMouseEventHandler;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellValueTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;
import org.kie.workbench.common.stunner.core.domainobject.DomainObject;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.util.ColumnIndexUtilities;
import org.uberfire.ext.wires.core.grids.client.util.CoordinateUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.dnd.IsRowDragHandle;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.NodeMouseEventHandler;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.DefaultGridWidgetCellSelectorMouseEventHandler;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.SelectionExtension;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLayerRedrawManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;

public abstract class BaseExpressionGrid<E extends Expression, D extends GridData, M extends BaseUIModelMapper<E>>
extends BaseGrid<E>
implements ExpressionGridCache.IsCacheable {
    public static final double DEFAULT_PADDING = 10.0;
    public static final Function<BaseExpressionGrid, Double> RESIZE_EXISTING = beg -> beg.getWidth() + beg.getPadding() * 2.0;
    public static final Function<BaseExpressionGrid, Double> RESIZE_EXISTING_MINIMUM = beg -> beg.getMinimumWidth() + beg.getPadding() * 2.0;
    protected final GridCellTuple parent;
    protected final DMNGridPanel gridPanel;
    protected final DefinitionUtils definitionUtils;
    protected final Event<ExpressionEditorChanged> editorSelectedEvent;
    protected final ListSelectorView.Presenter listSelector;
    protected final int nesting;
    protected M uiModelMapper;

    public BaseExpressionGrid(GridCellTuple parent, Optional<String> nodeUUID, HasExpression hasExpression, Optional<HasName> hasName, DMNGridPanel gridPanel, DMNGridLayer gridLayer, D gridData, GridRenderer gridRenderer, DefinitionUtils definitionUtils, SessionManager sessionManager, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, DefaultCanvasCommandFactory canvasCommandFactory, Event<ExpressionEditorChanged> editorSelectedEvent, Event<RefreshFormPropertiesEvent> refreshFormPropertiesEvent, Event<DomainObjectSelectionEvent> domainObjectSelectionEvent, CellEditorControlsView.Presenter cellEditorControls, ListSelectorView.Presenter listSelector, TranslationService translationService, boolean isOnlyVisualChangeAllowed, int nesting) {
        super(nodeUUID, hasExpression, hasName, gridLayer, (GridData)gridData, gridRenderer, sessionManager, sessionCommandManager, canvasCommandFactory, refreshFormPropertiesEvent, domainObjectSelectionEvent, cellEditorControls, translationService, isOnlyVisualChangeAllowed);
        this.parent = parent;
        this.gridPanel = gridPanel;
        this.definitionUtils = definitionUtils;
        this.editorSelectedEvent = editorSelectedEvent;
        this.listSelector = listSelector;
        this.nesting = nesting;
        this.doInitialisation();
    }

    protected void doInitialisation() {
        this.uiModelMapper = this.makeUiModelMapper();
        this.initialiseUiColumns();
        this.initialiseUiRows();
        this.initialiseUiCells();
    }

    protected abstract M makeUiModelMapper();

    protected abstract void initialiseUiColumns();

    protected abstract void initialiseUiRows();

    public abstract void initialiseUiCells();

    public <V, HV extends HasValue<V>> Consumer<HV> clearValueConsumer(boolean updateStunnerTitle, V emptyValue) {
        return hv -> {
            CompositeCommand.Builder commandBuilder = this.newHasValueHasNoValueCommand(hv, emptyValue);
            if (updateStunnerTitle) {
                this.getUpdateStunnerTitleCommand(emptyValue).ifPresent(arg_0 -> ((CompositeCommand.Builder)commandBuilder).addCommand(arg_0));
            }
            this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)commandBuilder.build());
        };
    }

    public <V, HV extends HasValue<V>> BiConsumer<HV, V> setValueConsumer(boolean updateStunnerTitle) {
        return (hv, value) -> {
            CompositeCommand.Builder commandBuilder = this.newHasValueHasValueCommand(hv, value);
            if (updateStunnerTitle) {
                this.getUpdateStunnerTitleCommand(value).ifPresent(arg_0 -> ((CompositeCommand.Builder)commandBuilder).addCommand(arg_0));
            }
            this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)commandBuilder.build());
        };
    }

    public BiConsumer<HasTypeRef, QName> setTypeRefConsumer() {
        return (htr, typeRef) -> this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)new SetTypeRefCommand((HasTypeRef)htr, (QName)typeRef, () -> {
            this.gridLayer.batch();
            this.selectedDomainObject.ifPresent(this::fireDomainObjectSelectionEvent);
        }));
    }

    protected <V, HV extends HasValue<V>> CompositeCommand.Builder newHasValueHasNoValueCommand(HV hasValue, V emptyValue) {
        CompositeCommand.Builder commandBuilder = new CompositeCommand.Builder();
        commandBuilder.addCommand(new DeleteHasValueCommand<V, HV>(hasValue, emptyValue, () -> {
            this.gridLayer.batch();
            this.selectedDomainObject.ifPresent(this::fireDomainObjectSelectionEvent);
        }));
        return commandBuilder;
    }

    protected <V, HV extends HasValue<V>> CompositeCommand.Builder newHasValueHasValueCommand(HV hasValue, V name) {
        CompositeCommand.Builder commandBuilder = new CompositeCommand.Builder();
        commandBuilder.addCommand(new SetHasValueCommand<V, HV>(hasValue, name, () -> {
            this.gridLayer.batch();
            this.selectedDomainObject.ifPresent(this::fireDomainObjectSelectionEvent);
        }));
        return commandBuilder;
    }

    protected <V> Optional<AbstractCanvasGraphCommand> getUpdateStunnerTitleCommand(V value) {
        AbstractCanvasGraphCommand command = null;
        if (this.getNodeUUID().isPresent()) {
            Definition definition;
            String nameId;
            String uuid = this.getNodeUUID().get();
            AbstractCanvasHandler canvasHandler = (AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler();
            Element element = canvasHandler.getGraphIndex().get(uuid);
            if (element.getContent() instanceof Definition && (nameId = this.definitionUtils.getNameIdentifier((definition = (Definition)element.getContent()).getDefinition())) != null) {
                command = (AbstractCanvasGraphCommand)this.canvasCommandFactory.updatePropertyValue(element, nameId, value);
            }
        }
        return Optional.ofNullable(command);
    }

    public TextAreaSingletonDOMElementFactory getBodyTextAreaFactory() {
        return new TextAreaSingletonDOMElementFactory(this.gridPanel, (GridLayer)this.gridLayer, (GridWidget)this, this.sessionManager, (SessionCommandManager<AbstractCanvasHandler>)this.sessionCommandManager, this.newCellHasNoValueCommand(), this.newCellHasValueCommand());
    }

    public AutocompleteTextAreaDOMElementFactory getAutocompleteTextareaFactory() {
        return new AutocompleteTextAreaDOMElementFactory(this.gridPanel, (GridLayer)this.gridLayer, (GridWidget)this, this.sessionManager, (SessionCommandManager<AbstractCanvasHandler>)this.sessionCommandManager, this.newCellHasNoValueCommand(), this.newCellHasValueCommand());
    }

    public ListBoxSingletonDOMElementFactory getBodyListBoxFactory() {
        return new ListBoxSingletonDOMElementFactory(this.gridPanel, (GridLayer)this.gridLayer, (GridWidget)this, this.sessionManager, (SessionCommandManager<AbstractCanvasHandler>)this.sessionCommandManager, this.newCellHasNoValueCommand(), this.newCellHasValueCommand());
    }

    protected Function<GridCellTuple, Command> newCellHasNoValueCommand() {
        return gridCellTuple -> new DeleteCellValueCommand((GridCellTuple)gridCellTuple, () -> this.uiModelMapper, this.gridLayer::batch);
    }

    protected Function<GridCellValueTuple, Command> newCellHasValueCommand() {
        return gridCellValueTuple -> new SetCellValueCommand((GridCellValueTuple)gridCellValueTuple, () -> this.uiModelMapper, this.gridLayer::batch);
    }

    public TextAreaSingletonDOMElementFactory getHeaderTextAreaFactory() {
        return new TextAreaSingletonDOMElementFactory(this.gridPanel, (GridLayer)this.gridLayer, (GridWidget)this, this.sessionManager, (SessionCommandManager<AbstractCanvasHandler>)this.sessionCommandManager, this.newHeaderHasNoValueCommand(), this.newHeaderHasValueCommand());
    }

    public TextBoxSingletonDOMElementFactory getHeaderTextBoxFactory() {
        return new TextBoxSingletonDOMElementFactory(this.gridPanel, (GridLayer)this.gridLayer, (GridWidget)this, this.sessionManager, (SessionCommandManager<AbstractCanvasHandler>)this.sessionCommandManager, this.newHeaderHasNoValueCommand(), this.newHeaderHasValueCommand());
    }

    protected Function<GridCellTuple, Command> newHeaderHasNoValueCommand() {
        return gc -> new DeleteHeaderValueCommand(this.extractEditableHeaderMetaData((GridCellTuple)gc), this.gridLayer::batch);
    }

    protected Function<GridCellValueTuple, Command> newHeaderHasValueCommand() {
        return gcv -> {
            String title = gcv.getValue().getValue().toString();
            return new SetHeaderValueCommand(title, this.extractEditableHeaderMetaData((GridCellTuple)gcv), this.gridLayer::batch);
        };
    }

    protected EditableHeaderMetaData extractEditableHeaderMetaData(GridCellTuple gc) {
        int headerRowIndex = gc.getRowIndex();
        int headerColumnIndex = gc.getColumnIndex();
        GridColumn.HeaderMetaData headerMetaData = (GridColumn.HeaderMetaData)((GridColumn)((BaseUIModelMapper)this.uiModelMapper).getUiModel().get().getColumns().get(headerColumnIndex)).getHeaderMetaData().get(headerRowIndex);
        if (headerMetaData instanceof EditableHeaderMetaData) {
            return (EditableHeaderMetaData)headerMetaData;
        }
        throw new IllegalArgumentException("Header (" + headerColumnIndex + ", " + headerRowIndex + ") was not an instanceof EditableHeaderMetaData");
    }

    public List<NodeMouseEventHandler> getNodeMouseClickEventHandlers(GridSelectionManager selectionManager) {
        ArrayList<NodeMouseEventHandler> handlers = new ArrayList<NodeMouseEventHandler>();
        handlers.add((NodeMouseEventHandler)new DefaultGridWidgetCellSelectorMouseEventHandler(selectionManager));
        handlers.add((NodeMouseEventHandler)new EditableHeaderGridWidgetEditCellMouseEventHandler());
        return handlers;
    }

    public List<NodeMouseEventHandler> getNodeMouseDoubleClickEventHandlers(GridSelectionManager selectionManager, GridPinnedModeManager pinnedModeManager) {
        ArrayList<NodeMouseEventHandler> handlers = new ArrayList<NodeMouseEventHandler>();
        handlers.add((NodeMouseEventHandler)new EditableHeaderGridWidgetEditCellMouseEventHandler());
        return handlers;
    }

    public boolean onDragHandle(INodeXYEvent event) {
        return false;
    }

    public DMNGridPanel getGridPanel() {
        return this.gridPanel;
    }

    public Viewport getViewport() {
        Viewport viewport = super.getViewport();
        if (viewport == null) {
            viewport = this.gridLayer.getViewport();
        }
        return viewport;
    }

    public Layer getLayer() {
        Object layer = super.getLayer();
        if (layer == null) {
            layer = this.gridLayer;
        }
        return layer;
    }

    public void select() {
        this.fireExpressionEditorChanged();
        super.select();
    }

    private void fireExpressionEditorChanged() {
        this.editorSelectedEvent.fire((Object)new ExpressionEditorChanged());
    }

    public void deselect() {
        this.fireExpressionEditorChanged();
        this.getModel().clearSelections();
        this.clearSelectedDomainObject();
        super.deselect();
    }

    void clearSelectedDomainObject() {
        this.selectedDomainObject = Optional.empty();
    }

    public double getPadding() {
        return 10.0;
    }

    public GridCellTuple getParentInformation() {
        return this.parent;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    public double getMinimumWidth() {
        double minimumWidth = 0.0;
        int columnCount = this.model.getColumnCount();
        List uiColumns = this.model.getColumns();
        for (int columnIndex = 0; columnIndex < columnCount - 1; ++columnIndex) {
            GridColumn editorColumn = (GridColumn)uiColumns.get(columnIndex);
            minimumWidth += editorColumn.getWidth();
        }
        if (columnCount > 0) {
            minimumWidth += ((GridColumn)uiColumns.get(columnCount - 1)).getMinimumWidth().doubleValue();
        }
        return minimumWidth;
    }

    public void resize(Function<BaseExpressionGrid, Double> requiredWidthSupplier) {
        this.doResize(new GridLayerRedrawManager.PrioritizedCommand(0){

            public void execute() {
                BaseExpressionGrid.this.getLayer().draw();
            }
        }, requiredWidthSupplier);
    }

    public void doResize(GridLayerRedrawManager.PrioritizedCommand command, Function<BaseExpressionGrid, Double> requiredWidthSupplier) {
        double proposedWidth = this.getWidth() + this.getPadding() * 2.0;
        this.getParentInformation().proposeContainingColumnWidth(proposedWidth, requiredWidthSupplier);
        this.getGridPanel().refreshScrollPosition();
        this.getGridPanel().updatePanelSize();
        this.getGridPanel().setFocus(true);
        this.getParentInformation().onResize();
        ((DMNGridLayer)this.getLayer()).batch(command);
    }

    public void selectFirstCell() {
        GridData uiModel = this.getModel();
        if (uiModel.getRowCount() == 0 || uiModel.getColumnCount() == 0) {
            return;
        }
        uiModel.clearSelections();
        uiModel.getColumns().stream().filter(c -> !(c instanceof IsRowDragHandle)).map(c -> uiModel.getColumns().indexOf(c)).findFirst().ifPresent(index -> this.selectCell(0, (int)index, false, false));
    }

    public boolean selectCell(Point2D ap, boolean isShiftKeyDown, boolean isControlKeyDown) {
        Integer uiRowIndex = CoordinateUtilities.getUiRowIndex((GridWidget)this, (double)ap.getY());
        Integer uiColumnIndex = CoordinateUtilities.getUiColumnIndex((GridWidget)this, (double)ap.getX());
        if (uiRowIndex == null || uiColumnIndex == null) {
            return false;
        }
        this.gridLayer.select((GridWidget)this);
        boolean isSelectionChanged = super.selectCell(uiRowIndex.intValue(), uiColumnIndex.intValue(), isShiftKeyDown, isControlKeyDown);
        if (isSelectionChanged) {
            this.doAfterSelectionChange(uiRowIndex, uiColumnIndex);
        }
        return isSelectionChanged;
    }

    public boolean selectCell(int uiRowIndex, int uiColumnIndex, boolean isShiftKeyDown, boolean isControlKeyDown) {
        this.gridLayer.select((GridWidget)this);
        boolean isSelectionChanged = super.selectCell(uiRowIndex, uiColumnIndex, isShiftKeyDown, isControlKeyDown);
        if (isSelectionChanged) {
            this.doAfterSelectionChange(uiRowIndex, uiColumnIndex);
        }
        return isSelectionChanged;
    }

    public boolean selectHeaderCell(Point2D ap, boolean isShiftKeyDown, boolean isControlKeyDown) {
        Integer uiHeaderRowIndex = CoordinateUtilities.getUiHeaderRowIndex((GridWidget)this, (Point2D)ap);
        Integer uiHeaderColumnIndex = CoordinateUtilities.getUiColumnIndex((GridWidget)this, (double)ap.getX());
        if (uiHeaderRowIndex == null || uiHeaderColumnIndex == null) {
            return false;
        }
        boolean isSelectionChanged = super.selectHeaderCell(uiHeaderRowIndex.intValue(), uiHeaderColumnIndex.intValue(), isShiftKeyDown, isControlKeyDown);
        if (isSelectionChanged) {
            this.doAfterHeaderSelectionChange(uiHeaderRowIndex, uiHeaderColumnIndex);
        }
        return isSelectionChanged;
    }

    public boolean selectHeaderCell(int uiHeaderRowIndex, int uiHeaderColumnIndex, boolean isShiftKeyDown, boolean isControlKeyDown) {
        boolean isSelectionChanged = super.selectHeaderCell(uiHeaderRowIndex, uiHeaderColumnIndex, isShiftKeyDown, isControlKeyDown);
        if (isSelectionChanged) {
            this.doAfterHeaderSelectionChange(uiHeaderRowIndex, uiHeaderColumnIndex);
        }
        return isSelectionChanged;
    }

    public boolean adjustSelection(SelectionExtension direction, boolean isShiftKeyDown) {
        boolean isSelectionChanged = super.adjustSelection(direction, isShiftKeyDown);
        if (isSelectionChanged) {
            if (this.getModel().getSelectedCells().size() > 0) {
                GridData.SelectedCell selectedCell = (GridData.SelectedCell)this.getModel().getSelectedCells().get(0);
                this.doAfterSelectionChange(selectedCell.getRowIndex(), ColumnIndexUtilities.findUiColumnIndex((List)this.getModel().getColumns(), (int)selectedCell.getColumnIndex()));
            } else if (this.getModel().getSelectedHeaderCells().size() > 0) {
                GridData.SelectedCell selectedHeraderCell = (GridData.SelectedCell)this.getModel().getSelectedHeaderCells().get(0);
                this.doAfterHeaderSelectionChange(selectedHeraderCell.getRowIndex(), ColumnIndexUtilities.findUiColumnIndex((List)this.getModel().getColumns(), (int)selectedHeraderCell.getColumnIndex()));
            }
        }
        return isSelectionChanged;
    }

    protected boolean hasAnyHeaderCellSelected() {
        return this.getModel().getSelectedHeaderCells().size() > 0;
    }

    protected boolean hasMultipleCellsSelected() {
        return this.getModel().getSelectedCells().size() > 1;
    }

    public void doAfterSelectionChange(int uiRowIndex, int uiColumnIndex) {
        this.fireDomainObjectSelectionEvent((DomainObject)new NOPDomainObject());
    }

    public void doAfterHeaderSelectionChange(int uiHeaderRowIndex, int uiHeaderColumnIndex) {
        this.fireDomainObjectSelectionEvent((DomainObject)new NOPDomainObject());
    }

    public void selectExpressionEditorFirstCell(int uiRowIndex, int uiColumnIndex) {
        GridCellValue value = this.model.getCell(uiRowIndex, uiColumnIndex).getValue();
        Optional grid = (Optional)((ExpressionCellValue)value).getValue();
        grid.ifPresent(beg -> {
            ((DMNGridLayer)this.getLayer()).select((GridWidget)beg);
            beg.selectFirstCell();
        });
    }

    public Optional<BaseExpressionGrid> findParentGrid() {
        GridWidget gridWidget = this.parent.getGridWidget();
        if (gridWidget instanceof BaseExpressionGrid) {
            return Optional.of((BaseExpressionGrid)gridWidget);
        }
        return Optional.empty();
    }
}

