/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid;

import com.ait.lienzo.client.core.types.Transform;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseBounds;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.TransformMediator;

public class BoundaryTransformMediator
implements TransformMediator {
    private double minX;
    private double minY;
    private double maxX;
    private double maxY;
    private final GridWidget gridWidget;

    public BoundaryTransformMediator(GridWidget gridWidget) {
        this.gridWidget = (GridWidget)PortablePreconditions.checkNotNull((String)"gridWidget", (Object)gridWidget);
        this.updateBounds();
    }

    private void updateBounds() {
        Bounds bounds = this.getBounds();
        this.minX = bounds.getX();
        this.minY = bounds.getY();
        this.maxX = this.minX + bounds.getWidth();
        this.maxY = this.minY + bounds.getHeight();
    }

    private Bounds getBounds() {
        return new BaseBounds(this.gridWidget.getX(), this.gridWidget.getY(), this.gridWidget.getWidth(), this.gridWidget.getHeight());
    }

    public Transform adjust(Transform transform, Bounds visibleBounds) {
        double visibleBoundsHeight;
        this.updateBounds();
        Transform newTransform = transform.copy();
        double scaleX = transform.getScaleX();
        double scaleY = transform.getScaleY();
        double translateX = newTransform.getTranslateX();
        double translateY = newTransform.getTranslateY();
        double scaledTranslateX = translateX / scaleX;
        double scaledTranslateY = translateY / scaleY;
        double visibleBoundsWidth = this.maxX > visibleBounds.getWidth() ? visibleBounds.getWidth() : this.maxX;
        double d = visibleBoundsHeight = this.maxY > visibleBounds.getHeight() ? visibleBounds.getHeight() : this.maxY;
        if (-scaledTranslateX < this.minX) {
            newTransform = newTransform.translate(-scaledTranslateX - this.minX, 0.0);
        }
        if (-scaledTranslateY < this.minY) {
            newTransform = newTransform.translate(0.0, -scaledTranslateY - this.minY);
        }
        if (-scaledTranslateX + visibleBoundsWidth > this.maxX) {
            newTransform = newTransform.translate(-scaledTranslateX + visibleBoundsWidth - this.maxX, 0.0);
        }
        if (-scaledTranslateY + visibleBoundsHeight > this.maxY) {
            newTransform = newTransform.translate(0.0, -scaledTranslateY + visibleBoundsHeight - this.maxY);
        }
        return newTransform;
    }
}

