/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.controls.popover;

import elemental2.dom.KeyboardEvent;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Element;
import org.jboss.errai.common.client.dom.EventListener;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.kie.workbench.common.dmn.client.editors.types.CanBeClosedByKeyboard;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.popover.PopoverView;
import org.uberfire.client.views.pfly.widgets.JQueryProducer;
import org.uberfire.client.views.pfly.widgets.Popover;
import org.uberfire.client.views.pfly.widgets.PopoverOptions;

public abstract class AbstractPopoverViewImpl
implements PopoverView {
    static final String ESCAPE_KEY = "Escape";
    static final String ESC_KEY = "Esc";
    static final String ENTER_KEY = "Enter";
    static final String PLACEMENT = "auto top";
    @DataField(value="popover")
    protected Div popoverElement;
    @DataField(value="popover-content")
    protected Div popoverContentElement;
    protected JQueryProducer.JQuery<Popover> jQueryPopover;
    protected Popover popover;
    protected boolean isVisible;
    protected EventListener closedByKeyboardEventListener = null;
    protected Optional<Consumer<CanBeClosedByKeyboard>> closedByKeyboardCallback = Optional.empty();

    protected AbstractPopoverViewImpl() {
    }

    public AbstractPopoverViewImpl(Div popoverElement, Div popoverContentElement, JQueryProducer.JQuery<Popover> jQueryPopover) {
        this.popoverElement = popoverElement;
        this.popoverContentElement = popoverContentElement;
        this.jQueryPopover = jQueryPopover;
    }

    @Override
    public void setOnClosedByKeyboardCallback(Consumer<CanBeClosedByKeyboard> callback) {
        this.closedByKeyboardCallback = Optional.ofNullable(callback);
    }

    @Override
    public void show(Optional<String> popoverTitle) {
        PopoverOptions options = this.createOptions();
        popoverTitle.ifPresent(t -> this.popoverElement.setAttribute("title", t));
        this.popover = (Popover)this.jQueryPopover.wrap((Element)this.getElement());
        this.popover.addShowListener(() -> {
            this.isVisible = true;
        });
        this.popover.addShownListener(() -> {
            this.isVisible = true;
            this.setKeyDownListeners();
            this.onShownFocus();
        });
        this.popover.addHideListener(() -> {
            this.isVisible = false;
        });
        this.popover.addHiddenListener(() -> {
            this.isVisible = false;
            this.clearKeyDownListeners();
        });
        this.popover.popover(options);
        this.popover.show();
    }

    PopoverOptions createOptions() {
        PopoverOptions options = this.createPopoverOptionsInstance();
        options.setContent(element -> this.popoverContentElement);
        options.setAnimation(Boolean.valueOf(false));
        options.setHtml(Boolean.valueOf(true));
        options.setPlacement(PLACEMENT);
        return options;
    }

    PopoverOptions createPopoverOptionsInstance() {
        return new PopoverOptions();
    }

    protected void onShownFocus() {
        this.popoverContentElement.getStyle().setProperty("outline", "none");
        this.popoverContentElement.focus();
    }

    @Override
    public void hide() {
        if (Objects.nonNull(this.popover)) {
            this.popover.hide();
            this.popover.destroy();
        }
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    protected void setKeyDownListeners() {
        if (Objects.isNull(this.closedByKeyboardEventListener)) {
            this.closedByKeyboardEventListener = this.getKeyDownEventListener();
            this.popoverElement.addEventListener("keydown", this.closedByKeyboardEventListener, false);
        }
    }

    protected void clearKeyDownListeners() {
        if (Objects.nonNull(this.closedByKeyboardEventListener)) {
            this.popoverElement.removeEventListener("keydown", this.closedByKeyboardEventListener, false);
            this.closedByKeyboardEventListener = null;
        }
    }

    protected EventListener getKeyDownEventListener() {
        return e -> this.keyDownEventListener(e);
    }

    public void keyDownEventListener(Object event) {
        if (event instanceof KeyboardEvent) {
            KeyboardEvent keyEvent = (KeyboardEvent)event;
            if (this.isEnterKeyPressed(keyEvent)) {
                this.hide();
                keyEvent.stopPropagation();
                this.onClosedByKeyboard();
            } else if (this.isEscapeKeyPressed(keyEvent)) {
                this.reset();
                this.hide();
                this.onClosedByKeyboard();
            }
        }
    }

    public boolean isEscapeKeyPressed(KeyboardEvent event) {
        return Objects.equals(event.key, ESC_KEY) || Objects.equals(event.key, ESCAPE_KEY);
    }

    public boolean isEnterKeyPressed(KeyboardEvent event) {
        return Objects.equals(event.key, ENTER_KEY);
    }

    public void onClosedByKeyboard() {
        this.getClosedByKeyboardCallback().ifPresent(c -> c.accept(this));
    }

    public Optional<Consumer<CanBeClosedByKeyboard>> getClosedByKeyboardCallback() {
        return this.closedByKeyboardCallback;
    }
}

