/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.handlers;

import com.ait.lienzo.client.core.event.AbstractNodeMouseEvent;
import com.ait.lienzo.client.core.types.Point2D;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.kie.workbench.common.dmn.client.editors.expressions.util.DynamicReadOnlyUtils;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditableHeaderMetaData;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditableHeaderUtilities;
import org.uberfire.ext.wires.core.grids.client.model.GridCellEditAction;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.util.CellContextUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.DefaultGridWidgetEditCellMouseEventHandler;

public class EditableHeaderGridWidgetEditCellMouseEventHandler
extends DefaultGridWidgetEditCellMouseEventHandler {
    public boolean onNodeMouseEvent(GridWidget gridWidget, Point2D relativeLocation, Optional<Integer> uiHeaderRowIndex, Optional<Integer> uiHeaderColumnIndex, Optional<Integer> uiRowIndex, Optional<Integer> uiColumnIndex, AbstractNodeMouseEvent event) {
        if (DynamicReadOnlyUtils.isOnlyVisualChangeAllowed(gridWidget)) {
            return false;
        }
        return super.onNodeMouseEvent(gridWidget, relativeLocation, uiHeaderRowIndex, uiHeaderColumnIndex, uiRowIndex, uiColumnIndex, event);
    }

    public boolean handleHeaderCell(GridWidget gridWidget, Point2D relativeLocation, int uiHeaderRowIndex, int uiHeaderColumnIndex, AbstractNodeMouseEvent event) {
        List gridColumns = gridWidget.getModel().getColumns();
        GridColumn gridColumn = (GridColumn)gridColumns.get(uiHeaderColumnIndex);
        List gridColumnHeaderMetaData = gridColumn.getHeaderMetaData();
        if (Objects.isNull(gridColumnHeaderMetaData) || gridColumnHeaderMetaData.isEmpty()) {
            return false;
        }
        if (!EditableHeaderUtilities.hasEditableHeader(gridColumn)) {
            return false;
        }
        if (!EditableHeaderUtilities.isEditableHeader(gridColumn, uiHeaderRowIndex)) {
            return false;
        }
        EditableHeaderMetaData editableHeaderMetaData = (EditableHeaderMetaData)gridColumn.getHeaderMetaData().get(uiHeaderRowIndex);
        if (Objects.equals(editableHeaderMetaData.getSupportedEditAction(), GridCellEditAction.getSupportedEditAction((AbstractNodeMouseEvent)event))) {
            Point2D gridWidgetComputedLocation = gridWidget.getComputedLocation();
            CellContextUtilities.editSelectedCell((GridWidget)gridWidget, (Point2D)relativeLocation.add(gridWidgetComputedLocation));
            return true;
        }
        return false;
    }
}

