/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.layer;

import java.util.Optional;
import java.util.function.Consumer;
import javax.enterprise.context.Dependent;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayerControl;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasControl;
import org.kie.workbench.common.stunner.core.client.canvas.listener.CanvasDomainObjectListener;
import org.kie.workbench.common.stunner.core.client.canvas.listener.CanvasElementListener;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.domainobject.DomainObject;
import org.kie.workbench.common.stunner.core.graph.Element;

@Dependent
public class DMNGridLayerControlImpl
extends AbstractCanvasControl<AbstractCanvas>
implements DMNGridLayerControl {
    private DMNGridLayer gridLayer;
    private Optional<ClientSession> session = Optional.empty();
    private CanvasElementListener redrawElementListener = new CanvasElementListener(){

        public void update(Element item) {
            DMNGridLayerControlImpl.this.gridLayer.batch();
        }
    };
    private CanvasDomainObjectListener redrawDomainObjectListener = new CanvasDomainObjectListener(){

        public void update(DomainObject domainObject) {
            DMNGridLayerControlImpl.this.gridLayer.batch();
        }
    };

    public DMNGridLayerControlImpl() {
        this.gridLayer = this.makeGridLayer();
    }

    DMNGridLayer makeGridLayer() {
        return new DMNGridLayer();
    }

    public void bind(ClientSession session) {
        this.session = Optional.ofNullable(session);
    }

    protected void doInit() {
        this.withCanvasHandler(abstractCanvasHandler -> {
            abstractCanvasHandler.addRegistrationListener(this.redrawElementListener);
            abstractCanvasHandler.addDomainObjectListener(this.redrawDomainObjectListener);
        });
    }

    protected void doDestroy() {
        this.withCanvasHandler(abstractCanvasHandler -> {
            abstractCanvasHandler.removeRegistrationListener(this.redrawElementListener);
            abstractCanvasHandler.removeDomainObjectListener(this.redrawDomainObjectListener);
        });
        this.session = Optional.empty();
        this.gridLayer = null;
    }

    private void withCanvasHandler(Consumer<AbstractCanvasHandler> consumer) {
        this.session.ifPresent(s -> {
            CanvasHandler canvasHandler = s.getCanvasHandler();
            if (canvasHandler instanceof AbstractCanvasHandler) {
                AbstractCanvasHandler abstractCanvasHandler = (AbstractCanvasHandler)canvasHandler;
                consumer.accept(abstractCanvasHandler);
            }
        });
    }

    @Override
    public DMNGridLayer getGridLayer() {
        return this.gridLayer;
    }
}

