/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.api;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.appformer.client.context.Channel;
import org.appformer.client.context.EditorContextProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.api.ReadOnlyProviderImpl;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class ReadOnlyProviderImplTest {
    @Mock
    private EditorContextProvider contextProvider;
    private ReadOnlyProviderImpl readOnlyProvider;

    @Before
    public void setup() {
        this.readOnlyProvider = new ReadOnlyProviderImpl(this.contextProvider);
    }

    @Test
    public void testIsReadOnlyDiagramWhenIsGithub() {
        Mockito.when((Object)this.contextProvider.getChannel()).thenReturn((Object)Channel.GITHUB);
        Assert.assertFalse((boolean)this.readOnlyProvider.isReadOnlyDiagram());
    }

    @Test
    public void testIsReadOnlyDiagramWhenIsDefault() {
        Mockito.when((Object)this.contextProvider.getChannel()).thenReturn((Object)Channel.DEFAULT);
        Assert.assertFalse((boolean)this.readOnlyProvider.isReadOnlyDiagram());
    }

    @Test
    public void testIsReadOnlyDiagramWhenIsVsCode() {
        Mockito.when((Object)this.contextProvider.getChannel()).thenReturn((Object)Channel.VSCODE);
        Assert.assertFalse((boolean)this.readOnlyProvider.isReadOnlyDiagram());
    }

    @Test
    public void testIsReadOnlyDiagramWhenIsOnline() {
        Mockito.when((Object)this.contextProvider.getChannel()).thenReturn((Object)Channel.ONLINE);
        Assert.assertFalse((boolean)this.readOnlyProvider.isReadOnlyDiagram());
    }

    @Test
    public void testIsReadOnlyDiagramWhenIsDesktop() {
        Mockito.when((Object)this.contextProvider.getChannel()).thenReturn((Object)Channel.DESKTOP);
        Assert.assertFalse((boolean)this.readOnlyProvider.isReadOnlyDiagram());
    }

    @Test
    public void testIsReadOnlyDiagramWhenIsEmbedded() {
        Mockito.when((Object)this.contextProvider.getChannel()).thenReturn((Object)Channel.EMBEDDED);
        Assert.assertFalse((boolean)this.readOnlyProvider.isReadOnlyDiagram());
    }
}

