/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.dtable;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.model.RuleAnnotationClause;
import org.kie.workbench.common.dmn.api.definition.model.RuleAnnotationClauseText;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.commands.expressions.types.dtable.AddRuleAnnotationClauseCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableUIModelMapper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.RuleAnnotationClauseColumn;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class AddRuleAnnotationClauseCommandTest {
    @Mock
    private DecisionTable decisionTable;
    @Mock
    private RuleAnnotationClause ruleAnnotationClause;
    @Mock
    private GridData uiModel;
    @Mock
    private Supplier<RuleAnnotationClauseColumn> uiModelColumnSupplier;
    private final int uiColumnIndex = 4;
    @Mock
    private DecisionTableUIModelMapper uiModelMapper;
    @Mock
    private Command executeCanvasOperation;
    @Mock
    private Command undoCanvasOperation;
    @Mock
    private List<Double> componentsWidths;
    @Mock
    private List<RuleAnnotationClause> annotations;
    @Captor
    private ArgumentCaptor<RuleAnnotationClauseText> clauseTextCaptor;
    private AddRuleAnnotationClauseCommand command;

    @Before
    public void setup() {
        this.command = (AddRuleAnnotationClauseCommand)Mockito.spy((Object)new AddRuleAnnotationClauseCommand(this.decisionTable, this.ruleAnnotationClause, this.uiModel, this.uiModelColumnSupplier, 4, this.uiModelMapper, this.executeCanvasOperation, this.undoCanvasOperation));
        Mockito.when((Object)this.decisionTable.getComponentWidths()).thenReturn(this.componentsWidths);
        Mockito.when((Object)this.decisionTable.getAnnotations()).thenReturn(this.annotations);
    }

    @Test
    public void testNewGraphCommandExecute() {
        AbstractCanvasHandler context = (AbstractCanvasHandler)Mockito.mock(AbstractCanvasHandler.class);
        GraphCommandExecutionContext executionContext = (GraphCommandExecutionContext)Mockito.mock(GraphCommandExecutionContext.class);
        DecisionRule rule1 = (DecisionRule)Mockito.mock(DecisionRule.class);
        DecisionRule rule2 = (DecisionRule)Mockito.mock(DecisionRule.class);
        List<DecisionRule> rules = Arrays.asList(rule1, rule2);
        int clauseIndex = 2;
        Name ruleAnnotationClauseName = (Name)Mockito.mock(Name.class);
        List rule1AnnotationEntries = (List)Mockito.mock(List.class);
        List rule2AnnotationEntries = (List)Mockito.mock(List.class);
        ((AddRuleAnnotationClauseCommand)Mockito.doReturn((Object)2).when((Object)this.command)).getClauseIndex();
        Mockito.when((Object)rule1.getAnnotationEntry()).thenReturn((Object)rule1AnnotationEntries);
        Mockito.when((Object)rule2.getAnnotationEntry()).thenReturn((Object)rule2AnnotationEntries);
        Mockito.when((Object)this.ruleAnnotationClause.getName()).thenReturn((Object)ruleAnnotationClauseName);
        Mockito.when((Object)this.decisionTable.getRule()).thenReturn(rules);
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(context);
        CommandResult commandResult = graphCommand.execute((Object)executionContext);
        ((List)Mockito.verify((Object)rule1AnnotationEntries)).add(Matchers.eq((int)2), this.clauseTextCaptor.capture());
        ((List)Mockito.verify((Object)rule2AnnotationEntries)).add(Matchers.eq((int)2), this.clauseTextCaptor.capture());
        ((List)Mockito.verify(this.componentsWidths)).add(4, null);
        ((List)Mockito.verify(this.annotations)).add(2, this.ruleAnnotationClause);
        ((RuleAnnotationClause)Mockito.verify((Object)this.ruleAnnotationClause)).setParent((DMNModelInstrumentedBase)this.decisionTable);
        List capturedValues = this.clauseTextCaptor.getAllValues();
        Assert.assertEquals((long)2L, (long)capturedValues.size());
        Assert.assertEquals((Object)"", (Object)((RuleAnnotationClauseText)capturedValues.get(0)).getText().getValue());
        Assert.assertEquals((Object)"", (Object)((RuleAnnotationClauseText)capturedValues.get(1)).getText().getValue());
        Assert.assertEquals((Object)rule1, (Object)((RuleAnnotationClauseText)capturedValues.get(0)).getParent());
        Assert.assertEquals((Object)rule2, (Object)((RuleAnnotationClauseText)capturedValues.get(1)).getParent());
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)commandResult);
    }

    @Test
    public void testNewGraphCommandUndo() {
        AbstractCanvasHandler context = (AbstractCanvasHandler)Mockito.mock(AbstractCanvasHandler.class);
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(context);
        GraphCommandExecutionContext executionContext = (GraphCommandExecutionContext)Mockito.mock(GraphCommandExecutionContext.class);
        int ruleAnnotationIndex = 3;
        DecisionRule rule1 = (DecisionRule)Mockito.mock(DecisionRule.class);
        DecisionRule rule2 = (DecisionRule)Mockito.mock(DecisionRule.class);
        List rule1AnnotationEntries = (List)Mockito.mock(List.class);
        List rule2AnnotationEntries = (List)Mockito.mock(List.class);
        List<DecisionRule> rules = Arrays.asList(rule1, rule2);
        Mockito.when((Object)rule1.getAnnotationEntry()).thenReturn((Object)rule1AnnotationEntries);
        Mockito.when((Object)rule2.getAnnotationEntry()).thenReturn((Object)rule2AnnotationEntries);
        Mockito.when((Object)this.decisionTable.getRule()).thenReturn(rules);
        Mockito.when((Object)this.annotations.indexOf(this.ruleAnnotationClause)).thenReturn((Object)3);
        CommandResult undoResult = graphCommand.undo((Object)executionContext);
        ((List)Mockito.verify(this.componentsWidths)).remove(4);
        ((List)Mockito.verify((Object)rule1AnnotationEntries)).remove(3);
        ((List)Mockito.verify((Object)rule2AnnotationEntries)).remove(3);
        ((List)Mockito.verify(this.annotations)).remove(this.ruleAnnotationClause);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)undoResult);
    }

    @Test
    public void testGetClauseIndex() {
        List dtOutputs = (List)Mockito.mock(List.class);
        List dtInputs = (List)Mockito.mock(List.class);
        int outputsSize = 3;
        int inputsSize = 7;
        Mockito.when((Object)dtOutputs.size()).thenReturn((Object)3);
        Mockito.when((Object)dtInputs.size()).thenReturn((Object)7);
        Mockito.when((Object)this.decisionTable.getOutput()).thenReturn((Object)dtOutputs);
        Mockito.when((Object)this.decisionTable.getInput()).thenReturn((Object)dtInputs);
        int expected = -7;
        int actual = this.command.getClauseIndex();
        ((List)Mockito.verify((Object)dtOutputs)).size();
        ((List)Mockito.verify((Object)dtInputs)).size();
        Assert.assertEquals((long)-7L, (long)actual);
    }

    @Test
    public void testNewCanvasCommandExecute() {
        AbstractCanvasHandler canvasHandler = (AbstractCanvasHandler)Mockito.mock(AbstractCanvasHandler.class);
        org.kie.workbench.common.stunner.core.command.Command canvasCommand = this.command.newCanvasCommand(canvasHandler);
        RuleAnnotationClauseColumn column = (RuleAnnotationClauseColumn)Mockito.mock(RuleAnnotationClauseColumn.class);
        List rules = (List)Mockito.mock(List.class);
        Mockito.when((Object)rules.size()).thenReturn((Object)3);
        Mockito.when((Object)this.decisionTable.getRule()).thenReturn((Object)rules);
        Mockito.when((Object)this.uiModelColumnSupplier.get()).thenReturn((Object)column);
        CommandResult result = canvasCommand.execute((Object)canvasHandler);
        ((DecisionTableUIModelMapper)Mockito.verify((Object)this.uiModelMapper)).fromDMNModel(0, 4);
        ((DecisionTableUIModelMapper)Mockito.verify((Object)this.uiModelMapper)).fromDMNModel(1, 4);
        ((DecisionTableUIModelMapper)Mockito.verify((Object)this.uiModelMapper)).fromDMNModel(2, 4);
        ((AddRuleAnnotationClauseCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.executeCanvasOperation)).execute();
        ((Supplier)Mockito.verify(this.uiModelColumnSupplier)).get();
        ((GridData)Mockito.verify((Object)this.uiModel)).insertColumn(4, (GridColumn)column);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)result);
    }

    @Test
    public void testNewCanvasCommandUndo() {
        AbstractCanvasHandler canvasHandler = (AbstractCanvasHandler)Mockito.mock(AbstractCanvasHandler.class);
        org.kie.workbench.common.stunner.core.command.Command canvasCommand = this.command.newCanvasCommand(canvasHandler);
        RuleAnnotationClauseColumn column = (RuleAnnotationClauseColumn)Mockito.mock(RuleAnnotationClauseColumn.class);
        Optional<RuleAnnotationClauseColumn> uiModelColumn = Optional.of(column);
        ((AddRuleAnnotationClauseCommand)Mockito.doReturn(uiModelColumn).when((Object)this.command)).getUiModelColumn();
        CommandResult result = canvasCommand.undo((Object)canvasHandler);
        ((AddRuleAnnotationClauseCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.undoCanvasOperation)).execute();
        ((GridData)Mockito.verify((Object)this.uiModel)).deleteColumn((GridColumn)column);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)result);
    }
}

