/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.function;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.commands.expressions.types.function.UpdateParameterTypeRefCommand;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class UpdateParameterTypeRefCommandTest {
    private static final QName OLD_PARAMETER_TYPE_REF = new QName("", BuiltInType.STRING.getName());
    private static final QName NEW_PARAMETER_TYPE_REF = new QName("", BuiltInType.DATE.getName());
    @Mock
    private Command canvasOperation;
    @Mock
    private AbstractCanvasHandler handler;
    @Mock
    private GraphCommandExecutionContext gce;
    @Mock
    private RuleManager ruleManager;
    private InformationItem parameter;
    private UpdateParameterTypeRefCommand command;

    @Before
    public void setup() {
        this.parameter = new InformationItem();
        this.parameter.setTypeRef(OLD_PARAMETER_TYPE_REF);
        this.command = new UpdateParameterTypeRefCommand(this.parameter, NEW_PARAMETER_TYPE_REF, this.canvasOperation);
        ((AbstractCanvasHandler)Mockito.doReturn((Object)this.ruleManager).when((Object)this.handler)).getRuleManager();
    }

    @Test
    public void testGraphCommandAllow() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.gce));
    }

    @Test
    public void testGraphCommandExecute() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)NEW_PARAMETER_TYPE_REF, (Object)this.parameter.getTypeRef());
    }

    @Test
    public void testGraphCommandUndo() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        Assert.assertEquals((Object)OLD_PARAMETER_TYPE_REF, (Object)this.parameter.getTypeRef());
    }

    @Test
    public void testCanvasCommandAllow() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.handler));
    }

    @Test
    public void testCanvasCommandExecute() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.handler));
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandUndo() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.handler));
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }
}

